#-*- python -*-                        vim:set ts=4 sw=4:
#Opening and extracting of RAR archives. Popular amongst crackers :-)
# Done by Eckard Meyer
# Inherit from the archive.py class
from archive import *
# Making use of pipes in the system calls
import popen2
# Useful in string manipulations
import string
# Get os functionality
import os
# Muli-language support
import gettext
_ = gettext.gettext
# Enable user settings
from settings import *

class Unrar(Archive):
    '''
    Class Unrar
    For now all we can do is
        1.Listing of files
        2.Listsing directories in archives
        3.Extracting an archive to a destination directory

    What has to be done is:
        1. Removing a file from an archive
        2. Viewing files
    '''

    def __init__(self,name,None,None,None):
        '''
        This a constructor for the unrar class called by the gui.
        Since rar is commercial,which sucks, only extarct,list & lsitdir
        will be implemented.
        '''
        Archive.__init__(self,name,None,None,None)

        #Various command s used for listing and extracting
        self.list_cmd= PS ('unrar_path') + ' v '
        self.extract_cmd= PS ('unrar_path') + ' x -u '

        #This is a value used by the Progress bar to show... well...PROGRESS
        self.progress = 0.0
        
        #File/Dir counter       
        self.filecount = 0

        #Varaibles used to stro logging information to be displayed on user request
        self.log=''
        self.error_log=''       
        
    def available (self):
        return os.access (PS ('unrar_path'), os.X_OK)

    # Using unrar to list the contents fo an archive
    def list (self):
        ''' 
        The appropriate command to do the listing
        '''
        log=''
        error_log=''

        cmd = self.list_cmd+'"' + self.name + '"'
        self.log = cmd+'\n'

        #Define a var to return the list                    
        ret = []

        #Connect to the system via pipes
        (child_in,child_out,child_err) = popen2.popen3 (cmd)
        lines = child_in.readlines ()
        del lines[:8]
        del lines[-3:]

        #Finished using the pipe,so we close it
        child_in.close()

        #Check for errors in the system call    
        err = child_err.readlines ()
        child_err.close ()
        err = map (string.strip, err)
        lines = map (string.strip, lines)

        '''
        The formatiing of the output begins
        Stripping away all the uneccessary information
        '''

        index = 0
        while index < len(lines):
            try:
                '''
                Using the string split procedure, standard to python, to get all the variable - fields
                into a usable tuple.        
                ''' 
                name = lines[index]

                #Add the entry to the log file
                self.log=self.log+name+' '
                '''
                Since the output from unrar is odd,I had to build in a counter - index - to work my
                way around the problem of having the name in the even rows and attributes in the odd 
                rows
                '''
                index=index+1
                #Usin string split to break the input string up into variuos fields
                (size,packed,ratio,date,time,Permissions,crc,meth,ver) = string.split(lines[index],None,10)
                #Add the entry to the log file
                self.log=self.log+lines[index]+'\n'

                if ((Permissions[0]=='-')|(Permissions[1]=='.')):
                    pos = string.rfind(name,'/')
                    #If the file resides in the root directory,it has space as path(parent dir)
                    if pos == -1:
                        ret.append([name,size,'',date,time,Permissions])
                    else:
                        #Add the path filed in which th efile resides
                        path = name[:pos]
                        name_f = name[pos+1:]
                        ret.append([name_f,size,path,date,time,Permissions])                
            except ValueError: 
                self.error_log = self.error_log+lines[-2]

            except IndexError:
                self.error_log = self.error_log+lines[-2]

            index=index+1

        self.number_of_files = len(ret)

        #Just check whether an error has occured
        if self.error_log != '':
            self.error(self.error_log,self.log)
            self.error_log=''

        return ret

    def list_headers (self):
        '''
        Returns an additional paarmeter used in the file listing widget
        '''
        return [_('Permissions')]

    def list_dir (self):
        '''
        Called by the GUI to list files in the archive of type RAR
        '''
        log=''
        error_log=''

        #The appropriate command to do the listing of directories
        cmd = self.list_cmd+'"'+ self.name +'"'
        self.log=cmd+'\n'       
        #Return variable to hold the values necessary for the GUI
        ret = []

        #Open pipes to the system
        (child_in, child_out, child_err) = popen2.popen3 (cmd)
        lines = child_in.readlines ()
                                
        if string.find(lines[-2],'Seek error')==-1:
            del lines[:8]
            del lines[-3:]
            #Have to close the pipe(s)
            child_in.close ()
            err = child_err.readlines ()
            child_err.close ()
            err = map (string.strip, err)
            lines = map (string.strip, lines)
    
            #Pick all the attributes provided by the system call
            index=0
            while index<len(lines):
                try:
                    name=lines[index]
                    index=index+1
                    (size,packed,ratio,date,time,Permissions,crc,meth,ver) = string.split(lines[index],None,10)
                    #Add the entry to the log file
                    self.log=self.log+name+' '+lines[index]+'\n'
                    #Since we want to list DIRS, append only dirs to the list   
                    if ((Permissions[:1]=='d')|(Permissions[1]=='D')) :
                        ret.append(name+'/')
                    index=index+1
                except ValueError:
                    self.error_log = self.error_log + lines
                except IndexError:
                    self.error_log = self.error_log + lines
        else:
            self.error_log=self.error_log+lines[-2]
        
        self.filecount = len(ret)

        #Check if there where errors
        if self.error_log !='':
            self.error(self.error_log,self.log)
            self.error_log=''

        return ret
        
    def extract(self,to,with_path,files):
        '''
        Call this with a path and a tuple of files
        to : Where to extract the archive to
        with_path: boolean which tells whether the files should be
               extracted with full paths or not.
        files: The individual files to extract. If this is the empty
                list [], extract everything
        '''
        log=''
        error_log=''

        old=os.getcwd()
        os.chdir(to)

        '''
        This function gives the user 2 choices
        a.Extract all the files to a destination
        b.Extract selected files only,to a destintion directory
        '''
        
        if(files==[]):
            #Extracting all the files to the target dir
            cmd = self.extract_cmd+'"'+self.name+'"'
            #Add command to the log file
            self.log=cmd+'\n'

            (child_in,child_out,child_err)=popen2.popen3(cmd)
            lines=child_in.readline()
            child_in.close()
            err = child_err.readline()
            child_err.close()
        else:
            #Extract only selected files to a target directory
            i = 0
            while i < len(files):
                try:    
                    temp = files[i]
                    #Extracting files that reside in the root of the archive
                    if temp[0]=='/':
                        cmd = self.extract_cmd+'"'+self.name+'" '+ temp[1:]
                    else:
                        cmd = self.extract_cmd+'"'+self.name+'" '+files[i]

                    #Add entry to the log file
                    self.log = self.log+cmd+'\n'

                    (c_in,c_out,c_err)=popen2.popen3(cmd)
                    lines=c_in.readline()
                    c_in.close()
                    err=c_err.readline()
                    c_err.close()
                    i=i+1
                except ValueError:
                    self.error_log=self.error_log+lines[index]+'\n'
                except IndexError:
                    self.error_log=self.error_log+lines[index]+'\n'
     
        os.chdir(old)   

        #if there was an error display it to the user
        if self.error_log!='':
            self.error(self.error_log,self.log)
            self.error_log=''
        
    def get_log(self):
        '''
        Retruns the log file to the GUI on user request
        '''
        return self.log


    def view(self,file):
        '''
        The view function takes 2 parameters taht enables the user to 
        view the a seelcted file in the archive
        file : File to be viewed
        '''
        tmp=self.make_tempfile(file)
        cmd= PS ('unrar_path') + ' p "'+self.name+'" '+file+' >'+tmp
        os.system(cmd)
        return tmp
