''' -*- python -*-                        vim:set ts=4 sw=4:

    FILE: "/home/life/projects/garchiver/src/DirListing.py"
    LAST MODIFICATION: "Sat, 30 Jun 2001 02:23:36 +0200 (life)"

    (C) 2000 by Danie Roux <droux@tuks.co.za>

$Id: DirListing.py,v 1.17 2001/06/19 12:53:09 droux Exp $

pygnome binding for the dir_listing widget.
'''


# Low level gtk
import _gtk
# High level (classed) gtk
import gtk
# For the gnome popup menu's
from gnome.ui import *

# Fix libs
import _load_imlib

# My widget to be bound
import _gtk_dir_listing

class GtkDirListing (gtk.GtkBin):
    ''' This is the python binding of the dir_listing C widget. '''
    # Points to the function
    get_type = _gtk_dir_listing.gtk_dir_listing_get_type
    
    # Returns the attribs of this widget. In this case it is only the
    # CTree that acts as the tree of files that is accesible
    def __getattr__ (self, attr):
        ''' Used to get attributes about the object. '''
        if attr == 'ctree':
            # Calls the wrapper that returns a GtkObject. This object is
            # passed to GtkCTree to 'cast' it into a GtkCTree object. And
            # that is then returned to be used as you want
            return gtk.GtkCTree (_obj = \
                _gtk_dir_listing.gtk_dir_listing_get_ctree (self._o))

        # I don't own this attribute, pass it up to the parent
        return gtk.GtkBin.__getattr__ (self, attr)

    def on_ok_clicked (self, *args):
        if self.ctree.selection != None:
            self.emit ('dir_final_selection', self.ctree.selection)
            self.win.destroy ()

    def on_cancel_clicked (self, *args):
        self.win.destroy ()

    def __init__ (self, path=None, with_dotfiles = None, _obj = None):
        # If an gtk_dir_listing_object was sent, set the object to that
        # and return. Basically 'casts' the object into a GtkDirListing

        if _obj: 
            self._o = _obj
            return

        if with_dotfiles == None:
            self._o = _gtk_dir_listing.gtk_dir_listing_new ()
        else: 
            self._o = _gtk_dir_listing.gtk_dir_listing_new_with_dotfiles (with_dotfiles)

        # Add myself to the standard gtk. This is because of a little bug
        # in GtkBox.
        gtk._name2cls['GtkDirListing'] = GtkDirListing

        if path:
            self.cd (path)

        self.show_all ()

    def cd (self, path):
        ''' Changes the directory of this widget to path. '''
        _gtk_dir_listing.gtk_dir_listing_cd (self._o, path)

    def show_dotfiles (self, toggle):
        _gtk_dir_listing.gtk_dir_listing_show_dotfiles (self._o, int (toggle))
        
def __dir_selected_activated (widget, *args):
    print 'Dir selected!'

def __dir_selected_activated_a (*args):
    print 'Dir selected in standalone!'

if __name__  == '__main__' :
    
    win = gtk.GtkWindow (gtk.WINDOW_TOPLEVEL)
    win.set_title ('In another window')
    win.set_usize (300, 300)
    win.connect ('delete_event', gtk.mainquit)
    test = GtkDirListing (with_dotfiles = 0)

    # This is how you get the ctree widget from DirListing
    #tree = test.ctree

    test.connect ('dir_selected', __dir_selected_activated)
    test.cd ('/home/life/')

    win.add (test)
    win.show_all ()

    gtk.mainloop ()
