(declare (extended-bindings) (not constant-fold) (not safe))

(define v1 (##u64vector 0 111 18446744073709551615))
(define v2 (##make-u64vector 10))
(define v3 (##make-u64vector 10 111))
(define v4 (##make-u64vector 10 18446744073709551615))

(define (int= x y)
  (if (##fixnum? x)
      (and (##fixnum? y)
           (##fx= x y))
      (and (##bignum? x)
           (##bignum? y)
           (let ((len (##bignum.adigit-length x)))
             (and (##fx= len (##bignum.adigit-length y))
                  (let loop ((i (##fx- len 1)))
                    (if (##fx< i 0)
                        (and (##bignum.adigit-= x y i)
                             (loop (##fx- i 1)))
                        #t)))))))
        
(define (test v i expected)
  (println (##eq? v (##u64vector-set! v i 0)))
  (let ((val (##u64vector-ref v i))) 
    (println (if (int= val 0) "good" "bad")))
  (println (##eq? v (##u64vector-set! v i expected)))
  (let ((val (##u64vector-ref v i))) 
    (println (if (int= val expected) "good" "bad"))))

(test v1 0 0)
(test v1 1 111)
(test v1 2 18446744073709551615)

(test v2 9 0)
(test v3 9 111)
(test v4 9 18446744073709551615)
