#!/usr/bin/perl

# vb2gb - convert VB's .frm files to Gambas' .form and .class files
#
# usage: vb2gb <filename.frm>

use strict;

use Frm2Form;
use Frm2Class;

while (my $filename = shift) {

  # Expect .frm file names as input
  if ($filename !~ /.frm$/i) {
    die "Usage: vb2gb <filename.frm>";
  }

  # Read filename
  open (FILE, $filename) or die "Can't read '$filename': $!\n";
  my @file = <FILE>;
  close FILE;

  # Convert
  my $form  = &Frm2Form::Translate (@file);
  my $class = &Frm2Class::Translate (@file);

  # Fix filename
  ($filename) = $filename =~ /(.+)\.frm/i;

  # Write form file
  open (FILE, ">$filename.form") or die "Can't write to $filename.form: $!\n";
  print FILE $form;
  close FILE;

  # Write class file
  open (FILE, ">$filename.class") or die "Can't write to $filename.class: $!\n";
  print FILE $class;
  close FILE;
}
