/***************************************************************************

  common.h

  Common useful macros

  Copyright (C) 2000 Benot Minisini <gambas@freesurf.fr>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GB_COMMON_H
#define __GB_COMMON_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#if !defined(__cplusplus)

#ifndef FALSE
enum
{
  FALSE = 0,
  TRUE = 1
};
#endif

typedef
  char boolean;

typedef
  char bool;

#endif

typedef
  unsigned char uchar;

#if defined(__FreeBSD__) || defined(__CYGWIN__)
typedef
  unsigned long ulong;
#endif

#ifdef __FreeBSD__
/* Get definition for PATH_MAX */
#include <limits.h>
#endif

#ifdef __sun__
 /* PGS: The following #define prevents /usr/include/sys/mman.h on solaris
    from #define'ing PRIVATE to 0x20, thus breaking Gambas.
    Perhaps Gambas should use a different name?

    BM: yes, my PRIVATE symbol is stupid and useless. But it is clearer
    than static. I will remove it when I have enouch courage :-)
 */
#ifdef _POSIX_C_SOURCE
/* PGS: Stop compiler warnings when gcc on solaris does remember to define
   _POSIX_C_SOURCE, e.g. when compiling qt related files. */
#undef _POSIX_C_SOURCE
#endif
#define _POSIX_C_SOURCE 3
/* Get prototype for alloca() */
#include <alloca.h>
/* Get definition for PATH_MAX */
#include <limits.h>
/* Get definition for index() */
#include <strings.h>
#endif

#define PUBLIC
#ifdef PRIVATE
#undef PRIVATE
#endif
#define PRIVATE static
#define INLINE __inline__
#define EXTERN extern
#define PACKED __attribute__((packed))
#define NORETURN __attribute__((noreturn))
#define CONST __attribute__((const))

#define _(x) x

#define strclr(s) (*(s) = 0)

#define CLEAR(s) (memset(s, 0, sizeof(*s)))
/*#define SWAP(a, b) ((a) ^= (b), (b) ^= (a), (a) ^= (b))*/

#ifndef offsetof
#define offsetof(_type, _arg) ((size_t)&(((_type *)0)->_arg))
#endif

#define stradd(d, s) \
({ \
  char *_d = (d); \
  const char *_s = (s); \
  \
  for(;;) \
  { \
    if ((*_d = *_s) == 0) \
      break; \
    \
    _d++; \
    _s++; \
  } \
  \
  _d; \
})

/*
__inline__ long Max(long a, long b)
{
  return (a > b) ? a : b;
}

__inline__ long Min(long a, long b)
{
  return (a > b) ? b : a;
}
*/

#define Max(a, b) ({ int _a = (a), _b = (b); _a > _b ? _a : _b; })
#define Min(a, b) ({ int _a = (a), _b = (b); _a < _b ? _a : _b; })
#define MinMax(v, a, b) ({ int _v = (v), _a = (a), _b = (b); _v < _a ? _a : (_v > _b ? _b : _v); })


/*
__inline__ long MinMax(long val, long a, long b)
{
  if (val < a)
    return a;
  else if (val > b)
    return b;
  else
    return val;
}
*/

#define COPYRIGHT "(c) 2000-2004 Benot Minisini\n\n" \
  "This program is free software; you can redistribute it and/or \n" \
  "modify it under the terms of the GNU General Public License as \n" \
  "published by the Free Software Foundation; either version 1, or \n" \
  "(at your option) any later version.\n\n"

#endif /* __COMMON_H */
