/***************************************************************************

  CClipboard.cpp

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/


#define __CCLIPBOARD_CPP


#include "gambas.h"

#include <qapplication.h>
#include <qmime.h>
#include <qclipboard.h>
#include <qimage.h>
#include <qpicture.h>
#include <qdragobject.h>
#include <qcstring.h>
#include <qevent.h>

#include "CWidget.h"
#include "CImage.h"
#include "CClipboard.h"

CDRAG_INFO CDRAG_info = { 0 };

static void *CLASS_Image;

//static CCURSOR *_cursor = 0;
static CPICTURE *_picture = 0;


static int get_type(QMimeSource *src)
{
  if (QTextDrag::canDecode(src))
    return 1;
  else if (QImageDrag::canDecode(src))
    return 2;
  else
    return 0;
}

static QCString get_format(QMimeSource *src)
{
  QCString format = src->format();
  int pos;

  pos = format.find(';');
  if (pos >= 0)
    format = format.left(pos);

  return format;
}

static void paste(QMimeSource *data, char *fmt)
{
  CIMAGE *img;

  if (fmt)
  {
    if (get_format(data) != QCString(fmt))
    {
      GB.ReturnNull();
      return;
    }
  }

  if (QTextDrag::canDecode(data))
  {
    QString text;

    QTextDrag::decode(data, text);
    GB.ReturnNewZeroString(text.latin1());
  }
  else if (QImageDrag::canDecode(data))
  {
    GB.New((void **)&img, GB.FindClass("Image"), 0, 0);
    QImageDrag::decode(data, *(img->image));
    img->image->convertDepth(32);
    GB.ReturnObject(img);
  }
  else
    GB.ReturnNull();
}



/***************************************************************************

  Clipboard

***************************************************************************/

BEGIN_METHOD_VOID(CCLIPBOARD_init)

  CLASS_Image = GB.FindClass("Image");

END_METHOD

BEGIN_METHOD_VOID(CCLIPBOARD_clear)

  QApplication::clipboard()->clear();

END_METHOD


BEGIN_PROPERTY(CCLIPBOARD_format)

  GB.ReturnNewZeroString(get_format(QApplication::clipboard()->data()));

END_PROPERTY


BEGIN_PROPERTY(CCLIPBOARD_type)

  GB.ReturnInteger(get_type(QApplication::clipboard()->data()));

END_PROPERTY


BEGIN_METHOD(CCLIPBOARD_copy, GB_VARIANT data; GB_STRING format)

  QCString format;

  if (VARG(data).type == GB_T_STRING)
  {
    QTextDrag *drag = new QTextDrag();

    if (MISSING(format))
      format = "plain";
    else
    {
      format = GB.ToZeroString(ARG(format));
      if (format.left(5) != "text/")
        goto _BAD_FORMAT;
      format = format.mid(5);
      if (format.length() == 0)
        goto _BAD_FORMAT;
    }

    drag->setText(VARG(data)._string.value);
    drag->setSubtype(format);

    QApplication::clipboard()->setData(drag);
  }
  else if (VARG(data).type >= GB_T_OBJECT && GB.Is(VARG(data)._object.value, CLASS_Image))
  {
    CIMAGE *img;

    if (!MISSING(format))
      goto _BAD_FORMAT;

    img = (CIMAGE *)VARG(data)._object.value;

    QApplication::clipboard()->setImage(*(img->image));
  }
  else
    goto _BAD_FORMAT;

  return;

_BAD_FORMAT:

  GB.Error("Bad clipboard format");

END_METHOD


BEGIN_METHOD(CCLIPBOARD_paste, GB_STRING format)

  paste(QApplication::clipboard()->data(), MISSING(format) ?  NULL : GB.ToZeroString(ARG(format)));

END_METHOD


GB_DESC CClipboardDesc[] =
{
  GB_DECLARE("Clipboard", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", 0),
  GB_CONSTANT("Text", "i", 1),
  GB_CONSTANT("Image", "i", 2),

  GB_STATIC_METHOD("_init", NULL, CCLIPBOARD_init, NULL),

  GB_STATIC_METHOD("Clear", NULL, CCLIPBOARD_clear, NULL),

  GB_STATIC_PROPERTY_READ("Format", "s", CCLIPBOARD_format),
  GB_STATIC_PROPERTY_READ("Type", "i", CCLIPBOARD_type),

  GB_STATIC_METHOD("Copy", NULL, CCLIPBOARD_copy, "(Data)v[(Format)s]"),
  GB_STATIC_METHOD("Paste", "v", CCLIPBOARD_paste, "[(Format)s]"),

  GB_END_DECLARE
};


/***************************************************************************

  Drag

***************************************************************************/

void CDRAG_clear(bool valid)
{
  if (valid)
    CDRAG_info.valid++;
  else
    CDRAG_info.valid--;

  if (CDRAG_info.valid == 0)
    CLEAR(&CDRAG_info);
}

void CDRAG_drag(CWIDGET *source, GB_VARIANT_VALUE *data, GB_STRING *fmt)
{
  QDragObject *drag;
  QCString format;
  CIMAGE *img;

  if (GB.CheckObject(source))
    return;

  if (data->type == GB_T_STRING)
  {
     drag = new QTextDrag(source->widget);

    if (fmt == NULL)
      format = "plain";
    else
    {
      format = GB.ToZeroString(fmt);
      if (format.left(5) != "text/")
        goto _BAD_FORMAT;
      format = format.mid(5);
      if (format.length() == 0)
        goto _BAD_FORMAT;
    }

    ((QTextDrag *)drag)->setText(data->_string.value);
    ((QTextDrag *)drag)->setSubtype(format);
  }
  else if (data->type >= GB_T_OBJECT && GB.Is(data->_object.value, CLASS_Image))
  {
    if (fmt)
      goto _BAD_FORMAT;

    drag = new QImageDrag(source->widget);

    img = (CIMAGE *)data->_object.value;

    ((QImageDrag *)drag)->setImage(*(img->image));
  }
  else
    goto _BAD_FORMAT;

  if (_picture)
  {
    //QPoint p(_cursor->x, _cursor->y);
    //pict = _cursor->picture;

    drag->setPixmap(*(_picture->pixmap));
  }

  drag->drag();

  return;

_BAD_FORMAT:

  GB.Error("Bad drag format");
}

BEGIN_METHOD(CDRAG_call, GB_OBJECT source; GB_VARIANT data; GB_STRING format)

  CDRAG_drag((CWIDGET *)VARG(source), &VARG(data), MISSING(format) ? NULL : ARG(format));

END_METHOD


BEGIN_METHOD_VOID(CDRAG_exit)

  GB.Unref((void **)&_picture);

END_METHOD

BEGIN_PROPERTY(CDRAG_picture)

  if (READ_PROPERTY)
    GB.ReturnObject(_picture);
  else
    GB.StoreObject(PROP(GB_OBJECT), (void **)&_picture);

END_PROPERTY

#define CHECK_VALID() \
  if (!CDRAG_info.valid) \
  { \
    GB.Error("No drag data"); \
    return; \
  }


BEGIN_PROPERTY(CDRAG_type)

  CHECK_VALID();

  GB.ReturnInteger(get_type(CDRAG_info.drop));

END_PROPERTY


BEGIN_PROPERTY(CDRAG_format)

  CHECK_VALID();

  GB.ReturnNewZeroString(get_format(CDRAG_info.drop));

END_PROPERTY


BEGIN_PROPERTY(CDRAG_data)

  if (!CDRAG_info.valid)
  {
    GB.ReturnNull();
    return;
  }

  paste(CDRAG_info.drop, NULL);

END_PROPERTY


BEGIN_PROPERTY(CDRAG_action)

  CHECK_VALID();

  switch(CDRAG_info.drop->action())
  {
    case QDropEvent::Link:
      GB.ReturnInteger(1);
      break;

    case QDropEvent::Move:
      GB.ReturnInteger(2);
      break;

    default:
      GB.ReturnInteger(1);
      break;
  }

END_PROPERTY


BEGIN_PROPERTY(CDRAG_source)

  CHECK_VALID();

  GB.ReturnObject(CWidget::get(CDRAG_info.drop->source()));

END_PROPERTY


BEGIN_PROPERTY(CDRAG_x)

  CHECK_VALID();

  GB.ReturnInteger(CDRAG_info.x);

END_PROPERTY


BEGIN_PROPERTY(CDRAG_y)

  CHECK_VALID();

  GB.ReturnInteger(CDRAG_info.y);

END_PROPERTY


GB_DESC CDragDesc[] =
{
  GB_DECLARE("Drag", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", 0),
  GB_CONSTANT("Text", "i", 1),
  GB_CONSTANT("Image", "i", 2),

  GB_CONSTANT("Copy", "i", 0),
  GB_CONSTANT("Link", "i", 1),
  GB_CONSTANT("Move", "i", 2),

  GB_STATIC_PROPERTY("Icon", "Picture", CDRAG_picture),

  GB_STATIC_PROPERTY_READ("Data", "v", CDRAG_data),
  GB_STATIC_PROPERTY_READ("Format", "s", CDRAG_format),
  GB_STATIC_PROPERTY_READ("Type", "i", CDRAG_type),
  GB_STATIC_PROPERTY_READ("Action", "i", CDRAG_action),
  GB_STATIC_PROPERTY_READ("Source", "Control", CDRAG_source),
  GB_STATIC_PROPERTY_READ("X", "i", CDRAG_x),
  GB_STATIC_PROPERTY_READ("Y", "i", CDRAG_y),

  GB_STATIC_METHOD("_call", NULL, CDRAG_call, "(Source)Control;(Data)v[(Format)s]"),
  GB_STATIC_METHOD("_exit", NULL, CDRAG_exit, NULL),

  GB_END_DECLARE
};

