/***************************************************************************

  subr_test.c

  Test and Boolean routines

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/


#include "gb_common.h"
#include <math.h>

#include "gbx_value.h"
#include "gbx_subr.h"
#include "gbx_date.h"
#include "gbx_object.h"

#define STT_NAME   SUBR_eq
#define STT_TEST   ==

#include "gbx_subr_test_temp.h"


#define STT_NAME   SUBR_ne
#define STT_TEST   !=

#include "gbx_subr_test_temp.h"


#define STT_INEQUALITY
#define STT_NAME   SUBR_gt
#define STT_TEST   >

#include "gbx_subr_test_temp.h"


#define STT_INEQUALITY
#define STT_NAME   SUBR_lt
#define STT_TEST   <

#include "gbx_subr_test_temp.h"


#define STT_INEQUALITY
#define STT_NAME   SUBR_ge
#define STT_TEST   >=

#include "gbx_subr_test_temp.h"


#define STT_INEQUALITY
#define STT_NAME   SUBR_le
#define STT_TEST   <=

#include "gbx_subr_test_temp.h"


#define STT_NAME   SUBR_case
#define STT_TEST   ==
#define STT_CASE

#include "gbx_subr_test_temp.h"


PUBLIC void SUBR_bit(void)
{
  long val;
  long bit;
  TYPE type;
  int n;

  SUBR_ENTER_PARAM(2);

  type = PARAM->type;

  switch (type)
  {
    case T_BYTE: n = 8; break;
    case T_SHORT: n = 16; break;
    default: n = 32; type = T_INTEGER; break;
  }

  VALUE_conv(PARAM, T_INTEGER);
  val = PARAM->_integer.value;

  VALUE_conv(&PARAM[1], T_INTEGER);
  bit = PARAM[1]._integer.value;

  if ((bit < 0) || (bit >= n))
    THROW(E_ARG);

  RETURN->type = type;

  switch (EXEC_code & 0xF)
  {
    case 1: /* BClr */
      val &= ~(1 << bit);
      break;

    case 2: /* BSet */
      val |= (1 << bit);
      break;

    case 3: /* BTst */
      RETURN->type = T_BOOLEAN;
      val = (val & (1 << bit)) ? (-1) : 0;
      break;

    case 4: /* BChg */
      val ^= (1 << bit);
      break;

    case 5: /* Shl */
      val <<= bit;
      break;

    case 6: /* Shr */
      val >>= bit;
      break;

    case 7: /* Rol */
      val = (val << bit) | (val >> (n - bit));
      break;

    case 8: /* Ror */
      val = (val >> bit) | (val << (n - bit));
      break;

    default:
      EXEC_ILLEGAL();
  }

  RETURN->_integer.value = val;

  SUBR_LEAVE();
}


void SUBR_min_max(void)
{
  TYPE type = T_VOID;
  int i;
  boolean is_max;

  SUBR_ENTER();

  is_max = ((EXEC_code >> 8) == CODE_MAX);

  for (i = 0; i < NPARAM; i++)
  {
    VARIANT_undo(&PARAM[i]);
    type = Max(type, PARAM[i].type);
  }

  if (!TYPE_is_number_date(type))
    THROW(E_TYPE, "Number or Date", TYPE_get_name(type));

  VALUE_conv(PARAM, type);

  switch (type)
  {
    case T_FLOAT:

      for (i = 1; i < NPARAM; i++)
      {
        VALUE_conv(&PARAM[i], type);
        if ((PARAM[i]._float.value < PARAM[0]._float.value) ^ is_max)
          PARAM[0]._float.value = PARAM[i]._float.value;
      }
      break;

    case T_DATE:

      for (i = 1; i < NPARAM; i++)
      {
        VALUE_conv(&PARAM[i], type);
        if (DATE_comp_value(&PARAM[i], &PARAM[0]) == (is_max ? 1 : -1))
        {
          PARAM[0]._date.date = PARAM[i]._date.date;
          PARAM[0]._date.time = PARAM[i]._date.time;
        }
      }
      break;

    default:

      for (i = 1; i < NPARAM; i++)
      {
        VALUE_conv(&PARAM[i], type);
        if ((PARAM[i]._integer.value < PARAM[0]._integer.value) ^ is_max)
          PARAM[0]._integer.value = PARAM[i]._integer.value;
      }
      break;
  }

  SP -= NPARAM;
  SP++;
}


void SUBR_if(void)
{
  SUBR_ENTER();

  VALUE_conv(PARAM, T_BOOLEAN);

  if (NPARAM == 2)
  {
    if (PARAM->_boolean.value)
      *RETURN = PARAM[1];
    else
      VALUE_default(RETURN, PARAM[1].type);
  }
  else
  {
    VALUE_conv(&PARAM[2], PARAM[1].type);

    if (PARAM->_boolean.value)
      *RETURN = PARAM[1];
    else
      *RETURN = PARAM[2];
  }

  SUBR_LEAVE();
}


void SUBR_choose(void)
{
  int val;

  SUBR_ENTER();

  VALUE_conv(PARAM, T_INTEGER);
  val = PARAM->_integer.value;

  if (val >= 1 && val <= NPARAM)
  {
    VALUE_conv(&PARAM[val], T_VARIANT);
    *RETURN = PARAM[val];
  }
  else
  {
    RETURN->type = T_VARIANT;
    RETURN->_variant.vtype = T_NULL;
  }

  SUBR_LEAVE();
}
