<?php

/****************************************************************************
 * Copyright (C) 2005 BRITE NSW Pty Ltd.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation (version 2 of the License)
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ****************************************************************************/

require_once 'gallimimus/RSS_writer.php';

if (!defined('GALLIMIMUS_DB'))
{
	if (file_exists('./gallimimus.db'))
	{
		define('GALLIMIMUS_DB', './gallimimus.db');
	}
	else if (file_exists('/var/lib/gallimimus/gallimimus.db'))
	{
		define('GALLIMIMUS_DB', '/var/lib/gallimimus/gallimimus.db');
	}
	else
	{
		trigger_error("Gallimimus database location not defined; define GALLIMIMUS_DB", E_USER_ERROR);
		exit;
	}
}

function OpenDB()
{
	$DB = @sqlite_open(GALLIMIMUS_DB);

	if (!$DB)
	{
		trigger_error("Failed to open database ".GALLIMIMUS_DB, E_USER_ERROR);
	}
	else
	{
		return $DB;
	}
}

function ValidFeed($DB, $id)
{
	$qid = sqlite_quote($id);
	
	$res = sqlite_query($DB, "SELECT id FROM feeds WHERE id=$qid");
	return sqlite_num_rows($res);
}

function AddItem($feed, $title, $link, $description)
{
	if (!$description)
	{
		return;
	}
	
	$DB = OpenDB();
	
	$idate = sqlite_quote(gmdate('Y-m-d').'T'.gmdate('H:i:s').'Z');
	$qfeed = sqlite_quote($feed);
	$qtitle = sqlite_quote($title);
	$qlink = sqlite_quote($link);
	$qdesc = sqlite_quote($description);
	
	sqlite_query($DB, "INSERT INTO items (feed, title, link, description, date)
			VALUES ($qfeed, $qtitle, $qlink, $qdesc, $idate)");
}

function AddFeed($DB, $id, $title, $link, $desc, $logo = NULL)
{
	if (ValidFeed($DB, $id))
	{
		trigger_error("Feed already exists", E_USER_ERROR);
	}
	
	$qid = sqlite_quote($id);
	$qtitle = sqlite_quote($title);
	$qlink = sqlite_quote($link);
	$qdesc = sqlite_quote($desc);
	$qlogo = sqlite_quote($logo);
	
	$qry = "INSERT INTO feeds (id, title, link, description, logo)
			VALUES ($qid, $qtitle, $qlink, $qdesc, $qlogo)";
	if (!@sqlite_query($DB, $qry))
	{
		trigger_error("Query failed: $qry", E_USER_ERROR);
	}
}

function GetFeed($DB, $id)
{
	$feed = new RSS_writer;
	$feed->specification = "1.0";
	$feed->about = $_SERVER['REQUEST_URI'];

	$feed->rssnamespaces["dc"]="http://purl.org/dc/elements/1.1/";

	$qid = sqlite_quote($id);
	$res = sqlite_query($DB, "SELECT * FROM feeds WHERE id=$qid");
	$details = sqlite_fetch_array($res);
	
	$feedprops = array(
		'description' => $details['description'],
		'link' => $details['link'],
		'title' => $details['title']
		);
	$feed->addchannel($feedprops);

	if ($details['logo'])
	{
		$logo = array(
			'url' => $details['logo'],
			'link' => $details['link'],
			'title' => $details['title']
		);
		$feed->addimage($logo);
	}
	
	return $feed;
}

function FeedItems($DB, $id)
{
	$qid = sqlite_quote($id);
	$res = sqlite_query($DB, "SELECT * FROM items WHERE feed=$qid");
	$items = array();
	while ($row = sqlite_fetch_array($res))
	{
		$items[] = $row;
	}

	return $items;
}

function InitDB($DB)
{
	sqlite_query($DB, "CREATE TABLE feeds
			(
				id		VARCHAR(255) NOT NULL,
				description	VARCHAR(255) NOT NULL,
				link		VARCHAR(255) NOT NULL,
				title		VARCHAR(255) NOT NULL,
				logo		VARCHAR(255),
				PRIMARY KEY (id)
			)");

	sqlite_query($DB, "CREATE TABLE items
			(
				feed		VARCHAR(255) NOT NULL,
				description	VARCHAR(255) NOT NULL,
				link		VARCHAR(255) NOT NULL,
				title		VARCHAR(255) NOT NULL,
				date		VARCHAR(30) NOT NULL
			)");
}

function sqlite_quote($s)
{
	if ($s === NULL)
	{
		return 'NULL';
	}
	else
	{
		return "'".sqlite_escape_string($s)."'";
	}
}
