/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel
implements StatusUpdate {
    public static final String MODULE = "StatusBar";
    JProgressBar jProgress = new JProgressBar();
    JLabel jStatus = new JLabel();
    StatusLevelData[] data = new StatusLevelData[6];
    int currentLevel = -1;
    int progressWidth;

    public StatusBar(int progressWidth) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new StatusLevelData();
        }
        this.data[0].active = true;
        this.progressWidth = progressWidth;
        this.jbInit();
    }

    public StatusBar() {
        this(150);
    }

    boolean raiseLevel(int level) {
        if (level < this.currentLevel) {
            return false;
        }
        if (level > this.currentLevel) {
            this.currentLevel = level;
        }
        return true;
    }

    public void setStatus(String message) {
        this.updateProgressStatus(0, message);
    }

    public void startProgress(int level, int minValue, int maxValue, String message, boolean undetermined) {
        this.data[level].minValue = minValue;
        this.data[level].maxValue = maxValue;
        this.data[level].value = 0;
        this.data[level].message = message;
        this.data[level].undetermined = undetermined;
        this.data[level].active = true;
        if (this.raiseLevel(level)) {
            this.resetUIState();
        }
    }

    public void updateProgressValue(int level, int value) {
        this.data[level].value = value;
        if (level == this.currentLevel && this.data[level].active) {
            this.resetUIState();
        }
    }

    public void updateProgressValue(int level, int value, int maxValue) {
        this.data[level].maxValue = maxValue;
        this.data[level].value = value;
        if (level == this.currentLevel && this.data[level].active) {
            this.resetUIState();
        }
    }

    public void updateProgressStatus(int level, String message) {
        this.data[level].message = message;
        if (level == this.currentLevel && this.data[level].active) {
            this.resetUIState();
        }
    }

    public void setUndetermined(int level, boolean undetermined) {
    }

    public int getProgressValue(int level) {
        return this.data[level].value;
    }

    public int getProgressMinValue(int level) {
        return this.data[level].minValue;
    }

    public int getProgressMaxValue(int level) {
        return this.data[level].maxValue;
    }

    public void stopProgress(int level, String message) {
        this.data[0].message = message;
        if (level == this.currentLevel && this.data[level].active) {
            if (this.data[level].undeterminedThread != null) {
                this.data[level].undeterminedThread.interrupt();
                this.data[level].undeterminedThread = null;
            }
            this.data[level].minValue = 0;
            this.data[level].maxValue = 0;
            this.data[level].value = 0;
            this.data[level].undetermined = false;
            if (level > 0) {
                this.data[level].active = false;
            }
            while (this.currentLevel > 0 && !this.data[this.currentLevel].active) {
                --this.currentLevel;
            }
            this.resetUIState();
        }
    }

    public void setInProgress(boolean inProgress) {
        GalleryRemote._().getCore().setInProgress(inProgress);
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(DialogUtil.findParentWindow(this), message, GRI18n.getString(MODULE, "Error"), 0);
    }

    public void jbInit() {
        this.jProgress.setMinimumSize(new Dimension(10, 18));
        this.jProgress.setPreferredSize(new Dimension(this.progressWidth, 18));
        this.jProgress.setMaximumSize(new Dimension(this.progressWidth, 18));
        this.jProgress.setStringPainted(false);
        this.jStatus.setBorder(BorderFactory.createBevelBorder(1, Color.white, SystemColor.control, SystemColor.control, Color.gray));
        this.jStatus.setMinimumSize(new Dimension(100, 18));
        this.jStatus.setPreferredSize(new Dimension(100, 18));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jProgress, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void resetUIState() {
        Log.log(3, MODULE, "level: " + this.currentLevel + " - " + this.data[this.currentLevel].message + " - " + this.data[this.currentLevel].value);
        if (this.currentLevel >= 0) {
            block6: {
                this.jProgress.setMinimum(this.data[this.currentLevel].minValue);
                this.jProgress.setValue(this.data[this.currentLevel].value);
                this.jProgress.setMaximum(this.data[this.currentLevel].maxValue);
                try {
                    this.jProgress.setIndeterminate(this.data[this.currentLevel].undetermined);
                }
                catch (Throwable t) {
                    if (!this.data[this.currentLevel].undetermined || this.data[this.currentLevel].undeterminedThread != null) break block6;
                    this.data[this.currentLevel].undeterminedThread = new UndeterminedThread(this, this.currentLevel);
                    this.data[this.currentLevel].undeterminedThread.start();
                }
            }
            this.jStatus.setText(this.data[this.currentLevel].message);
        } else {
            this.jStatus.setText("");
            this.jProgress.setValue(this.jProgress.getMinimum());
            try {
                this.jProgress.setIndeterminate(false);
            }
            catch (Throwable t) {
                this.data[this.currentLevel].undeterminedThread.interrupt();
            }
        }
    }

    public class UndeterminedThread
    extends Thread {
        StatusUpdate su;
        int level;

        public UndeterminedThread(StatusUpdate su, int level) {
            this.su = su;
            this.level = level;
        }

        public void run() {
            boolean forward = true;
            while (!UndeterminedThread.interrupted()) {
                if (this.su.getProgressValue(this.level) >= this.su.getProgressMaxValue(this.level)) {
                    forward = false;
                } else if (this.su.getProgressValue(this.level) <= this.su.getProgressMinValue(this.level)) {
                    forward = true;
                }
                this.su.updateProgressValue(this.level, this.su.getProgressValue(this.level) + (forward ? 1 : -1));
                try {
                    UndeterminedThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class StatusLevelData {
        boolean active = false;
        String message;
        int minValue;
        int maxValue;
        int value;
        boolean undetermined;
        UndeterminedThread undeterminedThread;

        StatusLevelData() {
        }
    }
}

