/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include "xlink.h"

/*
 * In here is a little function that calls some low level X stuff to
 * determine if there is a current owner for the CLIPBOARD atom.
 * Frankly this ought to be possible by calling some gdk function,
 * however the closest one: gdk_selection_owner_get, also returns NULL
 * if the current owner is not a gdk window. So there is no way to
 * detect it if there is an non-gdk owner. Bummer.
 */
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <gdk/gdk.h>
extern Display *gdk_display;

gboolean
galeon_x_clipboard_present()
{
	GdkAtom clipboard_atom = gdk_atom_intern ("CLIPBOARD", FALSE);
	Window xwindow;

	xwindow=XGetSelectionOwner(gdk_display, clipboard_atom);
	return(xwindow!=None);
}
