namespace Galago.Tests
{
	using System;
	using Galago;

	public class GetPresence
	{
		public static int Main(string[] args)
		{
			if (args.Length != 2)
			{
				Console.WriteLine("Usage: get-presence.exe service-id " +
								  "username");
				return 1;
			}

			if (!Galago.Global.Init("get-presence"))
			{
				Console.WriteLine("Unable to initialize Galago");

				return 1;
			}

			string service_id = args[0];
			string username   = args[1];

			Service service = Galago.Global.GetService(service_id);

			if (service == null)
			{
				Console.WriteLine("Unknown service: " + service_id);
				return 1;
			}

			Account account = service.GetAccount(username);

			if (account == null)
			{
				Console.WriteLine("Unknown account " + username +
								  "on service " + service_id);
				return 1;
			}

			Console.WriteLine("Service:      " + service.Name);
			Console.WriteLine("Username:     " + account.Username);
			Console.WriteLine("Display name: " + account.DisplayName);

			Presence presence = account.Presence;

			if (presence == null)
			{
				Console.WriteLine("No presence");
			}
			else
			{
				Console.WriteLine("Idle:         " + presence.IsIdle);
				Console.WriteLine("Idle Time:    " + presence.IdleTime);

				Console.WriteLine("Status(es):");

				GLib.List statuses = presence.Statuses;

				foreach (Status status in statuses)
				{
					Console.WriteLine("\tType:    " + status.Primitive);
					Console.WriteLine("\tID:      " + status.Id);
					Console.WriteLine("\tName:    " + status.Name);
				}
			}

			return 0;
		}
	}
}
