/* GADMIN-SQUID - An easy to use GTK+ frontend for the Squid proxy server.
 * Copyright (C) 2006 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "functions.h"
#include "widgets.h"
#include "populate_cache_tab.h"
#include "show_info.h"



void populate_cache_tab(struct w *widgets)
{
    /* Lists squid errors and messages */
    FILE *fp;
    long file_size;
    char *line;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    int found = 0;
    gchar *utf8=NULL, *info=NULL, *cache_log;
    
    /* Default to the configured cache log */
    cache_log = g_strdup_printf("%s", CACHE_LOG);

    gtk_list_store_clear(widgets->cache_store);

    if((fp=fopen(cache_log, "r"))==NULL) 
    {
        info = g_strdup_printf(_("Cant open the cache log here:\n%s\n"), cache_log);
	show_info(info);
	g_free(info);
	g_free(cache_log);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

/*  Naah...
    if( file_size > 1000000 )
    {
        info = g_strdup_printf(_("The cache log is too large, clear it in the cache tab\n"));
	show_info(info);
	g_free(info);
	fclose(fp);	
	return;
    }
*/
    line = allocate(file_size+1);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	found = 1;

    	gtk_list_store_append(GTK_LIST_STORE(widgets->cache_store), &iter);
    	utf8 = g_locale_to_utf8(line, strlen(line)-1, NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->cache_store), &iter, 0, utf8, -1);
    }
    fclose(fp);
    free(line);
    g_free(cache_log);

    if(utf8!=NULL)
      g_free(utf8);

    /* Cant set treepath if there arent any rows, then itll crash */
    if( ! found )
      return;

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->error_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
