package g2p_sk::Trans_cod;
require 5.000;
require Exporter;
*import = \&Exporter::import;

@ISA = qw(Exporter);
@EXPORT = qw(clean_and_lc cod2uni uni2cod lc_1 set_debug_level mess);

use Term::ANSIColor qw(:constants);

warn "Loading module - Trans_cod ...\n";

my $prior=1;
my $color=0;
return true;

sub set_debug_level
{
   my $tmp=shift;
   my $tmpC=shift;
   return "Error - debug level out of range" if($tmp<0 or $tmp>5);
   $prior=$tmp;
   $color=$tmpC if($tmpC==0 or $tmpC==1);
   return "true";
}

sub clean_and_lc
  {
    mess('"Cistenie" textu ...',5);
    my $in=shift(@_);
    $_=$in;
    s/[\n]+//g;
    s/  / /g;
    s/[\.,;:-\?]/ \.;/g;
    s/!/ !;/g;
    s/[\"\']+//g;
    s/[ ]*$//;
    s/$/ \.;/;
    s/ \.; \.;$/ \.;/;
    s/ !; \.;$/ !;/;
    #$in=lc;
    $in=lc_1($_);
    return $in;
  }

sub cod2uni
  {
    mess("Prekodovanie do interneho kodovania ...",5);
    my %cod=('a'=>'!a!',''=>'!A!',''=>'!e!','b'=>'!b!','c'=>'!c!',''=>'!C!',
	     'd'=>'!d!',''=>'!D!','e'=>'!e!',''=>'!E!','f'=>'!f!','g'=>'!g!',
	     'h'=>'!h!','i'=>'!i!',''=>'!I!','j'=>'!j!','k'=>'!k!','l'=>'!l!',
	     ''=>'!ld!',''=>'!L!','m'=>'!m!','n'=>'!n!',''=>'!N!','o'=>'!o!',
	     ''=>'!O!',''=>'!uo!','p'=>'!p!','q'=>'!q!','r'=>'!r!',''=>'!rd!',
	     's'=>'!s!',''=>'!S!','t'=>'!t!',''=>'!T!','u'=>'!u!',''=>'!U!',
	     'v'=>'!v!','w'=>'!w!','x'=>'!x!','y'=>'!y!',''=>'!Y!','z'=>'!z!',
	     ''=>'!Z!','X'=>'!ch!','Y'=>'!dz!','W'=>'!dZ!');
    my $in=shift(@_);
    $in=~s/ch/X/g;
    $in=~s/dz/Y/g;
    $in=~s/d/W/g;
    my @chars=split('',$in);
    foreach $char (@chars)
      {
	$char=$cod{$char} || $char;
      }
    $in=join(' ',@chars);
    return $in;
  }

sub uni2cod
  {
    mess("Prekodovanie z interneho kodovania ...",5);
    my %cod=('!a!'=>'a','!A!'=>'','!e!'=>'','!b!'=>'b','!c!'=>'c','!C!'=>'',
	     '!d!'=>'d','!D!'=>'','!e!'=>'e','!E!'=>'','!f!'=>'f','!g!'=>'g',
	     '!h!'=>'h','!i!'=>'i','!I!'=>'','!j!'=>'j','!k!'=>'k','!l!'=>'l',
	     '!ld!'=>'','!L!'=>'','!m!'=>'m','!n!'=>'n','!N!'=>'','!o!'=>'o',
	     '!O!'=>'','!uo!'=>'','!p!'=>'p','!q!'=>'q','!r!'=>'r','!rd!'=>'',
	     '!s!'=>'s','!S!'=>'','!t!'=>'t','!T!'=>'','!u!'=>'u','!U!'=>'',
	     '!v!'=>'v','!w!'=>'w','!x!'=>'x','!y!'=>'y','!Y!'=>'','!z!'=>'z',
	     '!Z!'=>'','!ch!'=>'ch','!dz!'=>'dz','!dZ!'=>'d');
    my @cod=('!a!','!A!','!e!','!b!','!c!','!C!',
	     '!d!','!D!','!e!','!E!','!f!','!g!',
	     '!h!','!i!','!I!','!j!','!k!','!l!',
	     '!ld!','!L!','!m!','!n!','!N!','!o!',
	     '!O!','!uo!','!p!','!q!','!r!','!rd!',
	     '!s!','!S!','!t!','!T!','!u!','!U!',
	     '!v!','!w!','!x!','!y!','!Y!','!z!',
	     '!Z!','!ch!','!dz!','!dZ!');
    my $in=shift(@_);
    my @chars=split(' ',$in);
    foreach $char (@chars)
      {
	$char=$cod{$char} || $char;
      }
    $in=join('',@chars);
    return $in;
  }

sub lc_1
  {
    mess("Zmena vsetkych velkych pismen na male ...",5);
    my %ul1=('A'=>'a',''=>'','B'=>'b','C'=>'c',''=>'','D'=>'d',''=>'','E'=>'e',
	     ''=>'','F'=>'f','G'=>'g','H'=>'h','I'=>'i',''=>'','J'=>'j','K'=>'k',
	     'L'=>'l',''=>'',''=>'','M'=>'m','N'=>'n',''=>'','O'=>'o',''=>'',
	     ''=>'','P'=>'p','Q'=>'q','R'=>'r',''=>'','S'=>'s',''=>'','T'=>'t',
	     ''=>'','U'=>'u',''=>'','V'=>'v','W'=>'w','X'=>'x','Y'=>'y',''=>'',
	     'Z'=>'z',''=>'');
    
    my $in=shift(@_);
    my @chars=split('',$in);
    foreach $char (@chars)
      {
	$char=$ul1{$char} || $char;
      }
    $in=join('',@chars);
    return $in;
  }

sub mess
  {
    my($msg,$pr)=@_;
    if($pr <= $prior)
      {
        $nt=$pr-1; $ss="";
	for($x=0;$x<$nt;$x++){$ss.="\t";}
	print "$ss$msg \n" if($color==0);
        #1-YELLOW,BOLD,2-YELLOW,3-GREEN,         5-default
        print YELLOW,BOLD,"$msg \n",RESET if($pr==1 and $color==1);
        print YELLOW,"$ss$msg \n",RESET if($pr==2 and $color==1);
        print GREEN,"$ss$msg \n",RESET if($pr==3 and $color==1);
        print BLUE,"$ss$msg \n",RESET if($pr==4 and $color==1);
        print RESET,"$ss$msg \n" if($pr==5 and $color==1);
      }
  }


END { }

