<!--
   Filename:     0.9.5/FWBuilderPreferences.xslt
   Author:       Vadim Kurland
   Build date:   08/23/2001
   Last changed: 08/23/2001
   Version:      1.0.0
   Description:  translates fwbuilder user preferences from v0.9.5 to v0.9.6
                 This transformation changes version number and adds
		 UI attributes for the new ObjectTree view modes
-->

<xsl:stylesheet version="1.0"
       xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>


<xsl:output method="xml" version="1.0" 
   doctype-system="fwbuilder_preferences.dtd" indent="yes" encoding="utf-8"/>
<xsl:strip-space elements="*"/>

<xsl:template match="FWBuilderPreferences">
  <FWBuilderPreferences version="0.9.6">
  <xsl:apply-templates/>
  </FWBuilderPreferences>
</xsl:template>



<xsl:template match="UI">
<UI>

  <xsl:choose>
    <xsl:when test="ShowObjectPropertiesInTree"></xsl:when>
    <xsl:otherwise>
  <ShowObjectPropertiesInTree>false</ShowObjectPropertiesInTree>

  <xsl:choose>
    <xsl:when test="HideNavigationBar"></xsl:when>
    <xsl:otherwise>
  <HideNavigationBar>true</HideNavigationBar>

  <xsl:choose>
    <xsl:when test="RememberWindowPositionAndSize"></xsl:when>
    <xsl:otherwise>
  <RememberWindowPositionAndSize>false</RememberWindowPositionAndSize>

  <MainWindowX>0</MainWindowX>         
  <MainWindowY>0</MainWindowY>        
  <MainWindowW>0</MainWindowW>        
  <MainWindowH>0</MainWindowH>        
  <MainWindowDivider>0</MainWindowDivider>  
  <TreeWindowX>0</TreeWindowX>        
  <TreeWindowY>0</TreeWindowY>        
  <TreeWindowW>0</TreeWindowW>        
  <TreeWindowH>0</TreeWindowH>        
  <ObjWindowX>0</ObjWindowX>         
  <ObjWindowY>0</ObjWindowY>         
  <ObjWindowW>0</ObjWindowW>         
  <ObjWindowH>0</ObjWindowH>         

          <xsl:choose>
            <xsl:when test="ObjectTreeMode"></xsl:when>
            <xsl:otherwise>
  <ObjectTreeMode>Split</ObjectTreeMode>

	      <xsl:choose>
	        <xsl:when test="FloatObjectTree"></xsl:when>
	        <xsl:otherwise>
  <FloatObjectTree>false</FloatObjectTree>
	        </xsl:otherwise>     <!-- FloatObjectTree -->
	      </xsl:choose>
            </xsl:otherwise>         <!-- ObjectTreeMode  -->
          </xsl:choose>

    </xsl:otherwise>
    </xsl:choose>
    </xsl:otherwise>
    </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates/>
</UI>
</xsl:template>

<xsl:template match="*">
<xsl:copy-of select="."/>
</xsl:template>


</xsl:stylesheet>


