/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyListElement.hh,v 1.15 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLISTELEMENT_HH
#define _POLICYLISTELEMENT_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/RuleElement.hh"

class PolicyList;
class PolicyListItem;

class PolicyListElement : public  Gtk::Frame 
{
    friend class PolicyListItem;

    gint        x,y,width,height;
    gint        row,col;
    bool        selected;

    virtual gint key_press_event_impl(GdkEventKey* p0);
    virtual void drag_data_received_impl(GdkDragContext* p0,
					 gint p1,
					 gint p2,
					 GtkSelectionData* p3,
					 guint p4,
					 guint32 p5);

protected:

    Gtk::VBox                           *vbox;

    Gtk::Widget                         *selected_item;
    libfwbuilder::RuleElement           *rel;
    libfwbuilder::Rule                  *rule;
    bool                                 change_any_to_orig;

    virtual void size_allocate_impl(GtkAllocation *p0);

    void set_data_changed_flag(bool f);

    Gtk::Widget* get_first_child();
    Gtk::Widget* get_last_child();

public:

    PolicyListElement(gint row,  gint col, libfwbuilder::RuleElement *re);
    PolicyListElement(gint row,gint col);

    void remove_item_from_policy(PolicyListItem* pi);
//  void add_item_to_policy(string name);
    bool add_item_to_policy(libfwbuilder::FWObject *obj);
    void toggleNeg();

    int get_row() { return row; }
    int get_col() { return col; }

    int  getX()      { return x;  }
    int  getY()      { return y;  }
    gint getWidth()  {  return width;  }
    gint getHeight() {  return height; }

    void activate();
    void deactivate();

    void select(bool select_row=true);
    void set_current_selected(Gtk::Widget *itm);
    void select_first_child();
    void select_last_child();

    void deselect();
    void deselect_all();

    void request_focus();

    libfwbuilder::RuleElement* get_rule_element() { return rel; };

    virtual void popup_menu(PolicyListItem *itm);
};

class PolicyListRuleNum : public PolicyListElement {
    virtual gboolean drag_motion_impl(GdkDragContext* p0,
				      gint p1,gint p2,guint p3);
    virtual void drag_data_received_impl(GdkDragContext* p0,
					 gint p1,
					 gint p2,
					 GtkSelectionData* p3,
					 guint p4,
					 guint32 p5);

public:
    PolicyListRuleNum(gint row,gint col,gint rule_n,bool neg);
    virtual void popup_menu(PolicyListItem *itm);
};

/*******************************************************************/

class PolicyListRuleAction : public PolicyListElement {
    void rebuild();
    public:
    PolicyListRuleAction(gint row, gint col, libfwbuilder::Rule *r);
    virtual void popup_menu(PolicyListItem *itm);
};

/*******************************************************************/

class PolicyListRuleLog : public PolicyListElement {
    void rebuild();
    public:
    PolicyListRuleLog(gint row, gint col, libfwbuilder::Rule *r);
    virtual void popup_menu(PolicyListItem *itm);
};

/*******************************************************************/

class PolicyListRuleComment : public PolicyListElement {
    void rebuild();
    public:
    PolicyListRuleComment(gint row, gint col, libfwbuilder::Rule *r);
    virtual void popup_menu(PolicyListItem *itm);
};

/*******************************************************************/

class PolicyListRuleDir : public PolicyListElement {
    void rebuild();
    public:
    PolicyListRuleDir(gint row, gint col, libfwbuilder::Rule *r);
    virtual void popup_menu(PolicyListItem *itm);
};

/*******************************************************************/

class PolicyListRuleOpt : public PolicyListElement {
    void rebuild();
    public:
    PolicyListRuleOpt(gint row, gint col, libfwbuilder::Rule *r);
    virtual void popup_menu(PolicyListItem *itm);
};


#endif









