/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NATDialog.cc,v 1.11 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "fwbuilder/FWObjectDatabase.hh"
#include "NATDialog.hh"
#include "helpers.hh"

#include "fwbuilder/Firewall.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/NAT.hh"
#include "PolicyList.hh"
#include "main_window.hh"


using namespace libfwbuilder;


NATDialog::NATDialog(FWObject *obj)
{
    RuleSet *pol;

    object=obj;
    dialog_buttons=true;
    
    policylist_ptr=NULL;
    wpptr=NULL;

//    if (obj->getTypeName()=="NAT")  p =(Policy*)obj;
    if ( NAT::isA(obj) ) pol=RuleSet::cast(obj);
    else {

	remove();
	Gtk::Label *l=
	    manage(new Gtk::Label("Unsupported firewall platform "));
	add(*l);
	l->show();
	return;
    }

    policylist_ptr = manage(new PolicyList(pol));

    /*******************************************************************/

    /*  When user presses Enter while one of the policy items is selected,
     *  or chooses "Edit" pop-up menu item ,
     *    PolicyList sends signal open_item. 
     */

    policylist_ptr->open_item.connect(SigC::slot(this,&NATDialog::on_open_item));

    remove();

    Gtk::ScrolledWindow *sw=new Gtk::ScrolledWindow();
    sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    add(*sw);
    sw->show();

    sw->add_with_viewport(*policylist_ptr);
    policylist_ptr->show();

    set_name("nat_dialog");
}

NATDialog::~NATDialog()
{
//  if (policylist_ptr!=NULL)  delete policylist_ptr;
//  policylist_ptr=NULL;
}

void NATDialog::on_open_item(void *arg)
{
    FWObject *obj=(FWObject*)arg;
    if (obj!=NULL) main_w->schedule_open_object(obj->getId());
}


void NATDialog::on_policy_line_add()
{
  data_changed_flag(true);
}

void NATDialog::on_policy_line_remove()
{
  data_changed_flag(true);
}

void NATDialog::wrk2dlg()
{
    if (policylist_ptr!=NULL)
	policylist_ptr->Build();
}

bool NATDialog::dlg2wrk()
{
    return(true);
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void NATDialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    itm=find_widget("policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("insert_top",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("append_bottom",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("add_after",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("remove_current",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_up",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_down",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("rules_druid",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("compile_policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    FWObject *f=object;
    while (Firewall::cast(f)==NULL)
	f=f->getParent();

    FWOptions *fwopt = (Firewall::cast(f))->getOptionsObject();
		
    string inst_script=fwopt->getStr("inst_script");
    itm=find_widget("install_policy",main_menubar);
    if (itm) itm->set_sensitive( inst_script!="" );

}

