/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IconList.hh,v 1.6 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef ICONLIST_HH_
#define ICONLIST_HH_

#include <gtk--.h>
#include <gtk--/layout.h>

#include "config.h"

#include <vector>

class ObjectQuickView;

class Icon : public Gtk::EventBox {

    friend class IconList;

    Gtk::VBox     *vbox;
    guint          x,y,width,height;
    string         text;

    Gtk::Pixmap   *pixmap;
    Gtk::EventBox *bgr;
    Gtk::Label    *label;

    virtual void size_allocate_impl(GtkAllocation *p0);

    unsigned get_label_width();

    void activateObjectQuickView();
    void deactivateObjectQuickView();

    virtual gint enter_notify_event_impl(GdkEventCrossing* ev);
    virtual gint leave_notify_event_impl(GdkEventCrossing* ev);

    virtual void state_changed_impl(GtkStateType p0);
    virtual gint button_press_event_impl(GdkEventButton* p0);

    public:

    Icon(const string& icon_filename,const string& text);
    ~Icon();

    int get_width()  { return width;  }
    int get_height() { return height; }
    int get_x()      { return x;      }
    int get_y()      { return y;      }

};

/**
 *  This is a replacement widget for iconlist from libgnomeui
 *
 *  Current implementation is limited in that it supports only icons
 *  of the same size, placed in the nodes of regular lattice. Unlike
 *  iconlist from libgnomeui, this widget also supports selecting of icons
 *  and provides method to select and unselect icon and determine which
 *  icon is currently selected.
 */

class IconList : public Gtk::Layout {

    friend class Icon;

    guint              x,y,width,height;
    gint               current_selected;
    bool               fisrt_expose_event;

    vector<int>        icons_x;
    vector<int>        icons_y;
    vector<Icon*>      icons;

    int row_spacing, col_spacing, text_spacing, icon_width, icon_height;
    int border;

    void icon_clicked(Icon *icn);

    void move_focus(GtkDirectionType dir);

    void getNextPosition(int prev_idx, Icon *new_icn, int &x,int &y);

    protected:

    virtual void size_allocate_impl(GtkAllocation* p0);
    virtual void size_request_impl(GtkRequisition* p0);
    virtual gint expose_event_impl(GdkEventExpose* p0);
    virtual gint button_press_event_impl(GdkEventButton* p0);
    virtual gint key_press_event_impl(GdkEventKey* p0);


    public:

    IconList();
    virtual ~IconList();

    int get_x()      { return x;      }
    int get_y()      { return y;      }

    int append(const string& icon_filename,const string& text);

    void remove(int pos);

    void clear();

    int get_size() { return icons.size(); }

    void set_icon_data(int pos,gpointer data);
    gpointer get_icon_data(int pos);

    void freeze();
    void thaw();

    void moveto(int pos,double yalign);

    void set_border(int bdr);
    void set_row_spacing(int spacing);
    void set_col_spacing(int spacing);
    void set_text_spacing(int spacing);
    void set_icon_width(int w);
    void set_icon_height(int h);

    int  get_icon_at(int x,int y);
    int  get_selected() { return current_selected; }

    /**
     *  returns number of icons in the row, where icon number icn_n is
     *  located 
     */
    int get_items_per_row(unsigned icn_n=0);

    void select_icon(  unsigned idx);
    void unselect_icon(unsigned idx);
    int  unselect_all(GdkEvent* event,gpointer keep);

    void arrangeIcons(unsigned start_with=0);

};

#endif
