/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectBook.cc,v 1.13 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "glademm_support.hh"

#include "FWObjectBook.hh"
#include "ObjectTree.hh"
#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Group.hh"
#include "main_window.hh"

using namespace libfwbuilder;

FWObjectBook::FWObjectBook()
{
    set_name("FWObjectBook");
    glademm_set_Widget("FWObjectBook", this);

    mode="Split";

    nb=NULL;

/*
    nb=manage(new Gtk::Notebook());

    nb->set_show_tabs(true);
    nb->set_tab_border(0);
    
    nb->show();
    add(*nb);

    nb->switch_page.connect(SigC::slot(this, 
				       &FWObjectBook::on_switch_page));

*/
}

void FWObjectBook::setMode( const string &_mode )
{
    if (_mode!=mode) {
	mode=_mode;
	if (nb!=NULL) {
	    clearSelection();
	    main_w->ClearRightPane(true);
	    build();
	}
    }
}

void FWObjectBook::showPage(unsigned page_num)
{
    nb->set_page( page_num );
}

void FWObjectBook::addPage(const string& lib_name,const string& tab_name)
{
    ObjectTree *ot = manage(new ObjectTree(lib_name, 
      Preferences::global_prefs->getOptBool("/FWBuilderPreferences/UI/ShowObjectPropertiesInTree") ));
    Gtk::Label *lb = manage(new class Gtk::Label(tab_name));

    nb->pages().push_back(Gtk::Notebook_Helpers::TabElem(*ot, *lb));

    ot->show();

    ot->scheduleRebuild();

    int page=nb->pages().size()-1;  // notebook page numbers start from 0
    trees[page]=ot;
    libraries[page]=lib_name;
}

void FWObjectBook::scanObjectDatabase(FWObject *obj)
{
    string lib;

    vector<FWObject*>::iterator m;
    for (m=obj->begin(); m!=obj->end(); ++m) {

	lib=(*m)->getLibrary();

	bool present=false;
	for (unsigned i=0; i<nb->pages().size(); ++i)
	    if (libraries[i]==lib) { present=true; break; }

	if (!present)  //new library
	    addPage(lib,lib);

	scanObjectDatabase( (*m) );

    }

}

void   FWObjectBook::build()
{
/* remove old notebook widget and create new one */
    if (nb!=NULL) nb->hide();
    remove();

    trees.clear();
    libraries.clear();

    nb=manage(new Gtk::Notebook());

    nb->set_tab_border(0);
    
    nb->show();
    add(*nb);


    if (mode=="Split") {
/*
 *  first page: objects, created by user. Library==""
 */
	nb->set_show_tabs(true);
	addPage("","User");
	scanObjectDatabase( FWObjectDatabaseGUI::ScratchPad );
    }
    if (mode=="Combined") {
	addPage("All","");
	nb->set_show_tabs(false);
    }

    show_all();

    nb->switch_page.connect(SigC::slot(this, 
				       &FWObjectBook::on_switch_page));

    main_w->setCurrentLibrary("");
    main_w->schedule_open_object(FWObjectDatabaseGUI::ScratchPad->getId());
}


void FWObjectBook::on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1)
{
    assert(main_w!=NULL);

    if(!is_visible()) 
        return;

    BuiltinDialog *w=(BuiltinDialog*)glademm_get_Widget("BuiltinDialog");
    if (w==NULL) return;  // BuiltinDialog has not been created yet

    string dlg_lib=w->getObject()->getLibrary();

/* p1 is the new page number */
    ObjectTree *ot=trees[p1];
    if (ot && libraries[p1]!=dlg_lib )
	ot->clearSelection();


/*
    ObjectTree *ot=trees[p1];
    if (ot) {
	string id= ot->getCurrentSelection();
	main_w->schedule_open_object(id);
    }
*/
}

void   FWObjectBook::insertObject( const string &id )
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->insertObject(id);
}

void   FWObjectBook::insertObject( FWObject *o)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->insertObject(o);
}

void   FWObjectBook::removeObject( const string &id )
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->removeObject(id);
}

void   FWObjectBook::removeObject( FWObject *o)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->removeObject(o);
}

void   FWObjectBook::sortSubtree(const string &id)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->sortSubtree(id);
}

void   FWObjectBook::sortSubtree(FWObject *o)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->sortSubtree(o);
}


void   FWObjectBook::changeTreeLabel(const string &id)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->changeTreeLabel(id);
}

void   FWObjectBook::scheduleRebuildAndShow(const string &id)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->scheduleRebuildAndShow(id);
}

string FWObjectBook::getCurrentSelection()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    return ot->getCurrentSelection();
}

string FWObjectBook::getCurrentLibrary()
{
    unsigned page=nb->get_current_page_num();
    if ( libraries.count(page)!=0 ) return libraries[page];
    return string("All");
}

void   FWObjectBook::showObject(FWObject *o,const string &lib)
{
    ObjectTree *ot=NULL;
    ot = trees[0];

    if (mode=="Split")    {
/* system objects are present on all pages, 
 * switch page only for regular objects */
	for (unsigned i=0; i<nb->pages().size(); ++i)
	    if (libraries[i]==lib) {
		ot = trees[i];
		if ( ! Resources::isSystem(o))
		    showPage(i);
		break;
	    }
    }

    if (ot!=NULL)  ot->showObject(o);
}

void   FWObjectBook::showObject(const string &id, const string &lib)
{
    FWObject *o=FWObjectDatabaseGUI::ScratchPad->getById(id,true);
    if(o==NULL) return;

    showObject(o,lib);
}

void   FWObjectBook::showObject(FWObject *o)
{
    showObject(o,o->getLibrary());
}

void   FWObjectBook::showObject(const string &id)
{
    FWObject *o=FWObjectDatabaseGUI::ScratchPad->getById(id,true);
    if(o==NULL) return;

    showObject(o,o->getLibrary());
}

void   FWObjectBook::clearSelection()
{
    ObjectTree *ot;

    if (mode=="Split")    ot = trees[ nb->get_current_page_num() ];
    if (mode=="Combined") ot = trees[0];

    assert (ot!=NULL);
    ot->clearSelection();
}

void     FWObjectBook::clearSelectionOnAllPages(ObjectTree *tree)
{
    map<unsigned,class ObjectTree*>::iterator m;
    for (m=trees.begin(); m!=trees.end(); ++m) {
	if ( (*m).second == tree ) continue;
	(*m).second->clearSelection();
    }
}

string   FWObjectBook::getNextId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getNextId();
}

string   FWObjectBook::getPrevId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getPrevId();
}

string   FWObjectBook::getParentId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getParentId();
}
