#!/bin/sh



RPMROOT=/var/tmp/fwbuilder
EXPORTDIR=`pwd`/export
SPECFILE=fwbuilder.spec

mkdir -p ${EXPORTDIR}

./configure --prefix=/usr || exit 1

VERSION=`awk '/Version:/ { print $2; }' $SPECFILE`
TAR_FILE=fwbuilder-${VERSION}.tar.gz
SNAPSHOT_DIR=fwbuilder-${VERSION}

make distclean

if [ ! -f $SPECFILE ]; then
    echo "Can't find spec file"
    exit 1
fi

RPMFILES="acconfig.h               \
	  mkinstalldirs            \
	  config.h.in              \
	  ltmain.sh                \
	  ltconfig                 \
	  aclocal.m4               \
	  acsite.m4                \
	  Makefile.in              \
	  config.sub               \
	  config.guess             \
	  configure                \
	  install.sh               \
	  configure.in             \
	  build_rpm.sh             \
	  fwbuilder.spec.in        \
	  doc                      \
	  examples                 \
	  etc                      \
	  src"


cd ${EXPORTDIR}
rm -rf ${SNAPSHOT_DIR}
ln -s .. ${SNAPSHOT_DIR}

FILELIST=`for f in ${RPMFILES}; do echo ${SNAPSHOT_DIR}/$f; done`

tar -ch  --exclude CVS --exclude api --exclude Tutorial --exclude *.bak -f - ${FILELIST}  | gzip > ${TAR_FILE} 
cd ..

echo " === Building RPM for fwbuilder version $VERSION === "

mkdir -p ${RPMROOT}
mkdir -p ${RPMROOT}/SOURCES
mkdir -p ${RPMROOT}/BUILD
mkdir -p ${RPMROOT}/SPECS
mkdir -p ${RPMROOT}/SRCS
mkdir -p ${RPMROOT}/RPMS
mkdir -p ${RPMROOT}/RPMS/i386
mkdir -p ${RPMROOT}/SRPMS

if [ ! -d $EXPORTDIR ]; then
    echo "Can't find export directory"
    exit 1
else

    if [ ! -f ${EXPORTDIR}/${TAR_FILE} ]; then
	make tar
    fi

    cp ${EXPORTDIR}/${TAR_FILE} ${RPMROOT}/SOURCES
    cp ${SPECFILE} ${RPMROOT}/SPECS 
    cd ${RPMROOT}/SPECS

    DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`
    if test "x${DISTRO}" == "xMandrake"; then
        ARCH=`uname -m`
        if [ "X$ARCH" = "Xi686" ]; then
                RPMARCH="--target i586"
        fi
    fi

    rm -f .rpmmacros
    echo "%_topdir ${RPMROOT}" > .rpmmacros

    export HOME=`pwd`; rpm -ba $RPMARCH ${SPECFILE} 

fi

