#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>

int main(int argc, char **argv){
	char *user = NULL;
	char *pass = NULL;
	char *port = NULL;
	char *ip = NULL;
	char *host, *c;
	struct hostent *hst;
	struct in_addr addr;
	char cmd[1024];
	
	if(argc < 2){
		fprintf(stderr, "Need some arguments here, dude!\n");
		exit(-1);
	}
	
	host = argv[1];
	if((c = strchr(host, '@'))){
		user = host;
		host = c + 1;
		*c = '\0';
		
		if((c = strchr(user, ':'))){
			pass = c + 1;
			*c = '\0';
		}
	}
	
	if((c = strchr(host, ':'))){
		port = c + 1;
		*c = '\0';
	}
	
	if((user) && ((strlen(user) > 24) || (strlen(pass) > 24))){
		fprintf(stderr, "Argument too long! Trying to overflow?\n");
		exit(-1);
	}
	
	if((port) && (strlen(port) > 5)){
		fprintf(stderr, "Argument too long! Trying to overflow?\n");
		exit(-1);	
	}
	
	if((hst = gethostbyname(host)) == NULL){
		fprintf(stderr, "DNS lookup failed!\n");
		exit(-1);
	}
	
	memcpy(&addr.s_addr, hst->h_addr_list[0], hst->h_length);
	ip = inet_ntoa(addr);
	
	if((user)&&(!pass)){
		fprintf(stderr, "A password is required!\n");
		exit(-1);
	}
	
	sprintf(cmd, "-fstype=ftpfs,ip=%s", ip);
	if(user)
		sprintf(cmd, "%s,user=%s,pass=%s", cmd, user, pass);
	if(port)
		sprintf(cmd, "%s,port=%s", cmd, port);
		
	printf("%s none\n", cmd);
	return 0;
}

