#include <time.h>
#include <WINGs/WINGsP.h>
#include <grp.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>

#include "FSViewer.h"
#include "FSUtils.h"
#include "timestampWidget.h"
#include "config.h"

#define WIDTH               272
#define HEIGHT              272
#define PERM_WIDTH	    180
#define PERM_HEIGHT          92
#define LABEL_HEIGHT         16
#define LABEL_WIDTH          48
#define CHECK_BUTTON_WIDTH   43
#define CHECK_BUTTON_HEIGHT  16

static char *CHECK_BUTTON_OFF[] = {
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%.........................................%",
"%.........................................%",
"%.........................................%",
"%............... #...... #%...............%",
"%................ #.... #%................%",
"%................. #.. #%.................%",
"%...................#%#%..................%",
"%................... #%...................%",
"%.................. #%#...................%",
"%................. #%. #..................%",
"%................ #%... #.................%",
"%................#%..... #................%",
"%.........................................%",
"%.........................................%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"};

static char *CHECK_BUTTON_ON[] = {
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%",
"%.........................................%",
"%.........................................%",
"%.........................................%",
"%........................ #...............%",
"%....................... #%...............%",
"%...................... #%................%",
"%................. #.. #%.................%",
"%................. #% #%..................%",
"%................. % #%...................%",
"%.................  #%....................%",
"%................. #%.....................%",
"%.................#%......................%",
"%.........................................%",
"%.........................................%",
"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"};

typedef struct _Panel {
    WMFrame      *frame;
    char         *sectionName;
    
    CallbackRec   callbacks;

    WMWindow     *win;
    TimeStamp    *stamp;

    WMFrame      *timeF;
    WMFrame      *permF;

    WMButton     *permBtn[3][3];
    WMButton     *okBtn;
    WMButton     *revertBtn;

    WMLabel      *linkLabel;
    WMLabel      *sizeLabel;
    WMLabel      *ownerLabel;
    WMLabel      *groupLabel;

    WMPixmap     *offPixmap;
    WMPixmap     *onPixmap;

    FileInfo     *fileInfo;
    mode_t        currentPerm;

} _Panel;


static void
setPermissions(_Panel *panel)
{
    
    if(panel->currentPerm & S_IRUSR)
	WMSetButtonSelected(panel->permBtn[0][0], 1);
    else
	WMSetButtonSelected(panel->permBtn[0][0], 0);

    if(panel->currentPerm & S_IWUSR)
	WMSetButtonSelected(panel->permBtn[1][0], 1);
    else
	WMSetButtonSelected(panel->permBtn[1][0], 0);
    if(panel->currentPerm & S_IXUSR)
	WMSetButtonSelected(panel->permBtn[2][0], 1);
    else
	WMSetButtonSelected(panel->permBtn[2][0], 0);
    if(panel->currentPerm & S_IRGRP)
	WMSetButtonSelected(panel->permBtn[0][1], 1);
    else
	WMSetButtonSelected(panel->permBtn[0][1], 0);
    if(panel->currentPerm & S_IWGRP)
	WMSetButtonSelected(panel->permBtn[1][1], 1);
    else
	WMSetButtonSelected(panel->permBtn[1][1], 0);
    if(panel->currentPerm & S_IXGRP)
	WMSetButtonSelected(panel->permBtn[2][1], 1);
    else
	WMSetButtonSelected(panel->permBtn[2][1], 0);
    if(panel->currentPerm & S_IROTH)
	WMSetButtonSelected(panel->permBtn[0][2], 1);
    else
	WMSetButtonSelected(panel->permBtn[0][2], 0);
    if(panel->currentPerm & S_IWOTH)
	WMSetButtonSelected(panel->permBtn[1][2], 1);
    else
	WMSetButtonSelected(panel->permBtn[1][2], 0);
    if(panel->currentPerm & S_IXOTH)
	WMSetButtonSelected(panel->permBtn[2][2], 1);
    else
	WMSetButtonSelected(panel->permBtn[2][2], 0);

}

static void
initPermissions(_Panel *panel, struct stat *st)
{

    panel->currentPerm &= 0;

    if(st->st_mode & S_IRUSR)
	 panel->currentPerm |= S_IRUSR;
    if(st->st_mode & S_IWUSR)
	 panel->currentPerm |= S_IWUSR;
    if(st->st_mode & S_IXUSR)
	 panel->currentPerm |= S_IXUSR;
    if(st->st_mode & S_IRGRP)
	 panel->currentPerm |= S_IRGRP;
    if(st->st_mode & S_IWGRP)
	 panel->currentPerm |= S_IWGRP;
    if(st->st_mode & S_IXGRP)
	 panel->currentPerm |= S_IXGRP;
    if(st->st_mode & S_IROTH)
	 panel->currentPerm |= S_IROTH;
    if(st->st_mode & S_IWOTH)
	 panel->currentPerm |= S_IWOTH;
    if(st->st_mode & S_IXOTH)
	 panel->currentPerm |= S_IXOTH;

    setPermissions(panel);
}

static void
showData(_Panel *panel)
{
    char  buf[100];
    char *pathname;
    struct stat   *st;
    struct passwd *psswd;
    struct group  *grp;

    st = (struct stat *) wmalloc(sizeof(struct stat));
    
    pathname = (char *) wmalloc(strlen(panel->fileInfo->path)+
				strlen(panel->fileInfo->name)+1);
    strcpy(pathname, panel->fileInfo->path);
    if(panel->fileInfo->fileType != ROOT)
	strcat(pathname, panel->fileInfo->name);

    /* get  information of a file represented by pathname */
    if (stat(pathname, st) == -1)
	wwarning("%s %d: Stat Error", __FILE__, __LINE__);

    if(CLK)
	SetTimeStampWithTimeT(panel->stamp, (int) st->st_mtime);
    
    initPermissions(panel, st);
    
    grp = getgrgid(st->st_gid);
    if(grp)
	WMSetLabelText(panel->groupLabel, grp->gr_name);

    psswd = getpwuid(st->st_uid);
    if(psswd)
	WMSetLabelText(panel->ownerLabel, psswd->pw_name);    

    sprintf(buf, "%d Bytes\n", (int)st->st_size);
    WMSetLabelText(panel->sizeLabel, buf);

    if(S_ISLNK(st->st_mode))
    {
	readlink(pathname, buf, sizeof(buf));
	WMSetLabelText(panel->linkLabel, buf);
    }
    
    if (st)
    {
	free(st);
	st = NULL;
    }

    if(pathname)
	free(pathname);

}


static void
storeData(_Panel *panel)
{
    char buf[100];
    char *pathname;
    struct stat *st;
    mode_t permissions;
    int seterror;
    
    st = (struct stat *) wmalloc(sizeof(struct stat));
    pathname = (char *) wmalloc(strlen(panel->fileInfo->path)+
				strlen(panel->fileInfo->name)+1);
    
    strcpy(pathname, panel->fileInfo->path);
    if(panel->fileInfo->fileType != ROOT)
	strcat(pathname, panel->fileInfo->name);
    permissions = 0; 
    
    /* User Permission */
    if (WMGetButtonSelected(panel->permBtn[0][0]))
	permissions = permissions | S_IRUSR;
    if (WMGetButtonSelected(panel->permBtn[1][0]))
	permissions = permissions | S_IWUSR;
    if (WMGetButtonSelected(panel->permBtn[2][0]))
	permissions = permissions | S_IXUSR;
    /* Group Permissions */
    if (WMGetButtonSelected(panel->permBtn[0][1]))
	permissions = permissions | S_IRGRP;
    if (WMGetButtonSelected(panel->permBtn[1][1]))
	permissions = permissions | S_IWGRP;
    if (WMGetButtonSelected(panel->permBtn[2][1]))
	permissions = permissions | S_IXGRP;
    /* Other permissions */
    if (WMGetButtonSelected(panel->permBtn[0][2]))
	permissions = permissions | S_IROTH;
    if (WMGetButtonSelected(panel->permBtn[1][2]))
	permissions = permissions | S_IWOTH;
    if (WMGetButtonSelected(panel->permBtn[2][2]))
	permissions = permissions | S_IXOTH;
    
    /* now, set the permissions for the file */
    errno = chmod(pathname, permissions); 
    
    free(pathname);	
}

static void
createLinkLabels(_Panel *panel)
{
    WMLabel *l;

    l = WMCreateLabel(panel->frame);
    WMResizeWidget(l, 50, 16);
    WMMoveWidget(l, 4, 16);
    WMSetLabelText(l, "Link To:");
    WMSetLabelTextAlignment(l, WARight);
    WMSetLabelRelief(l, WRFlat);
    WMSetLabelTextColor(l, WMDarkGrayColor(WMWidgetScreen(panel->win)));

    panel->linkLabel = WMCreateLabel(panel->frame);
    WMResizeWidget(panel->linkLabel, PERM_WIDTH-LABEL_WIDTH-10, 16);
    WMMoveWidget(panel->linkLabel, LABEL_WIDTH+2, 16);
/*     WMSetLabelText(panel->linkLabel, "Link:"); */
    WMSetLabelRelief(panel->linkLabel, WRFlat);

}    

static void 
createSizeLabels(_Panel *panel)
{
    WMLabel *l;

    l = WMCreateLabel(panel->frame);
    WMResizeWidget(l, 48, 16);
    WMMoveWidget(l, 4, 56);
    WMSetLabelText(l, "Size:");
    WMSetLabelTextAlignment(l, WARight);
    WMSetLabelRelief(l, WRFlat);

    panel->sizeLabel = WMCreateLabel(panel->frame);
    WMResizeWidget(panel->sizeLabel, PERM_WIDTH-LABEL_WIDTH-10, 16);
    WMMoveWidget(panel->sizeLabel, LABEL_WIDTH+2, 56);
/*     WMSetLabelText(panel->sizeLabel, "Size"); */
    WMSetLabelRelief(panel->sizeLabel, WRFlat);

}

static void
createOwnerLabels(_Panel *panel)
{
    WMLabel *l;

    l = WMCreateLabel(panel->frame);
    WMResizeWidget(l, LABEL_WIDTH, LABEL_HEIGHT);
    WMMoveWidget(l, 4, 86);
    WMSetLabelText(l, "Owner:");
    WMSetLabelTextAlignment(l, WARight);
    WMSetLabelRelief(l, WRFlat);

    panel->ownerLabel = WMCreateLabel(panel->frame);
    WMResizeWidget(panel->ownerLabel, PERM_WIDTH-LABEL_WIDTH-10, LABEL_HEIGHT);
    WMMoveWidget(panel->ownerLabel, LABEL_WIDTH+2, 86);
/*     WMSetLabelText(panel->ownerLabel, "Owner"); */
    WMSetLabelRelief(panel->ownerLabel, WRFlat);

}

static void 
createGroupLabels(_Panel *panel)
{
    WMLabel *l;

    l = WMCreateLabel(panel->frame);
    WMResizeWidget(l, LABEL_WIDTH, LABEL_HEIGHT);
    WMMoveWidget(l, 4, 116);
    WMSetLabelText(l, "Group:");
    WMSetLabelTextAlignment(l, WARight);
    WMSetLabelRelief(l, WRFlat);

    panel->groupLabel = WMCreateLabel(panel->frame);
    WMResizeWidget(panel->groupLabel, PERM_WIDTH-LABEL_WIDTH-10, LABEL_HEIGHT);
    WMMoveWidget(panel->groupLabel, LABEL_WIDTH+2, 116);
    WMSetLabelRelief(panel->groupLabel, WRFlat);
    
}

static void
fillPermissionsFrame(WMScreen *scr, _Panel *panel, int x, int y, 
		     int row, int col)
{
    WMButton *btn;
    WMLabel *l;
    int i;
    int j;

    char *label[] = { "Read", "Write", "Exec", 
		      "Owner", "Group", "Other" };

    for(i=0; i < row; i++)
	for(j=0; j < col; j++)
	{
	    btn = WMCreateSwitchButton(panel->permF);
	    WMSetButtonImage(btn, panel->offPixmap);
	    WMSetButtonAltImage(btn, panel->onPixmap);
	    
	    WMSetButtonImagePosition(btn, WIPImageOnly);
	    WMSetButtonBordered(btn, False);
	    WMSetButtonEnabled(btn, True);
	    WMResizeWidget(btn, 43, LABEL_HEIGHT);
	    WMMoveWidget(btn, 0+43+(j*(43-1)), 
			 y+(i*(LABEL_HEIGHT-1)));

	    panel->permBtn[i][j] = btn;
	}
    
    for(i = 0; i < row; i++)
    {
	l = WMCreateLabel(panel->permF);
	WMResizeWidget(l, 34, LABEL_HEIGHT);
	WMMoveWidget(l, x, y+(LABEL_HEIGHT*i));
	WMSetLabelText(l, label[i]);
	WMSetLabelTextAlignment(l, WARight);
	WMSetLabelRelief(l, WRFlat);
    }

    for(i = 0; i < col; i++)
    {
	l = WMCreateLabel(panel->permF);
	WMResizeWidget(l, 42, LABEL_HEIGHT);
	WMMoveWidget(l, 1+42+(i*43), y+(LABEL_HEIGHT*row));
	WMSetLabelText(l, label[i+3]);
	WMSetLabelTextAlignment(l, WACenter);
	WMSetLabelRelief(l, WRFlat);
    }

}

static void
createPermissionsFrame(_Panel *panel)
{

    panel->permF = WMCreateFrame(panel->frame);
    WMResizeWidget(panel->permF, PERM_WIDTH, PERM_HEIGHT);
    WMMoveWidget(panel->permF, 8, HEIGHT-33-PERM_HEIGHT);
    WMSetFrameTitle(panel->permF, " Permissions ");
    fillPermissionsFrame(WMWidgetScreen(panel->win), panel, 6, 20, 3, 3);

}
static void
createChangedFrame(_Panel *panel)
{

    panel->timeF = WMCreateFrame(panel->frame);
    WMResizeWidget(panel->timeF, 68, PERM_HEIGHT);
    WMMoveWidget(panel->timeF, WIDTH-76, HEIGHT-33-PERM_HEIGHT);
    WMSetFrameTitle(panel->timeF, " Changed ");

    if(CLK)
    {
	InitTimeStamp(WMWidgetScreen(panel->win));
	panel->stamp = CreateTimeStamp(panel->timeF);
	WMResizeWidget(panel->stamp, 64, 64);
	WMMoveWidget(panel->stamp, 2, 14);
	SetTwentyFour(panel->stamp, True);
    }

}

static void
buttonClick(WMWidget *self, void *data)
{
    _Panel *panel = (_Panel *)data;

    if ((WMButton *)self == panel->okBtn) 
    {
	storeData(panel);
	showData(panel);
/* 	WMSetButtonEnabled(panel->okBtn, False); */
/* 	WMSetButtonEnabled(panel->revertBtn, True); */
    }	
    else
    {
	setPermissions(panel);
/* 	WMSetButtonEnabled(panel->okBtn, True); */
/* 	WMSetButtonEnabled(panel->revertBtn, False); */
    }
}

static void
createButtons(_Panel *panel)
{

    panel->revertBtn = WMCreateCommandButton(panel->frame);
    WMMoveWidget(panel->revertBtn, 16, HEIGHT-24);
    WMResizeWidget(panel->revertBtn, 115, 24);
    WMSetButtonText(panel->revertBtn, "Revert");
    WMSetButtonEnabled(panel->revertBtn, True);
    WMSetButtonAction(panel->revertBtn, buttonClick, panel);
   
    panel->okBtn = WMCreateCommandButton(panel->frame);
    WMMoveWidget(panel->okBtn, 140, HEIGHT-24);
    WMResizeWidget(panel->okBtn, 115, 24);
    WMSetButtonText(panel->okBtn, "OK");
    WMSetButtonImage(panel->okBtn, 
		     WMGetSystemPixmap(WMWidgetScreen(panel->win), 
				       WSIReturnArrow));
    WMSetButtonAltImage(panel->okBtn, 
			WMGetSystemPixmap(WMWidgetScreen(panel->win), 
					  WSIHighlightedReturnArrow));
    WMSetButtonImagePosition(panel->okBtn, WIPRight);
    WMSetButtonEnabled(panel->okBtn, True);
    WMSetButtonAction(panel->okBtn, buttonClick, panel);   
}

static void
createPanel(_Panel *p)
{
    _Panel *panel = (_Panel*)p;
    panel->frame = WMCreateFrame(panel->win);

    WMResizeWidget(panel->frame, WIDTH, HEIGHT);
    WMMoveWidget(panel->frame, 0, 138);
    WMSetFrameRelief(panel->frame, WRFlat);

    createChangedFrame(panel);
    createPermissionsFrame(panel);
    createLinkLabels(panel);
    createSizeLabels(panel);
    createOwnerLabels(panel);
    createGroupLabels(panel);
    createButtons(panel);

    WMRealizeWidget(panel->frame);
    WMMapSubwidgets(panel->frame);
    WMMapSubwidgets(panel->timeF);
    WMMapSubwidgets(panel->permF);

}



_Panel*
InitAttribs(WMWindow *win, FileInfo *fileInfo)
{
    _Panel *panel;

    panel = wmalloc(sizeof(_Panel));
    memset(panel, 0, sizeof(_Panel));

    panel->sectionName = (char *) wmalloc(strlen("Attributes Inspector")+1);
    strcpy(panel->sectionName, "Attributes Inspector");

    panel->win = win;

    panel->offPixmap = FSMakePixmap(WMWidgetScreen(win), CHECK_BUTTON_OFF,
				    CHECK_BUTTON_WIDTH,
				    CHECK_BUTTON_HEIGHT);
    panel->onPixmap  = FSMakePixmap(WMWidgetScreen(win), CHECK_BUTTON_ON,
				    CHECK_BUTTON_WIDTH,
				    CHECK_BUTTON_HEIGHT);
    
    panel->callbacks.createWidgets = createPanel;
    panel->callbacks.updateDomain = storeData;
    panel->callbacks.updateDisplay = showData;
    panel->fileInfo = fileInfo;

    return panel;
}
