/* resource.c generated by valac 0.14.2, the Vala compiler
 * generated from resource.vala, do not modify */

/*
 * FSO Resource Abstraction
 *
 * (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <freesmartphone.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <fsoframework.h>
#include <fsobasics.h>


#define USAGE_TYPE_IRESOURCE (usage_iresource_get_type ())
#define USAGE_IRESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_IRESOURCE, UsageIResource))
#define USAGE_IS_IRESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_IRESOURCE))
#define USAGE_IRESOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_TYPE_IRESOURCE, UsageIResourceIface))

typedef struct _UsageIResource UsageIResource;
typedef struct _UsageIResourceIface UsageIResourceIface;

#define USAGE_TYPE_RESOURCE (usage_resource_get_type ())
#define USAGE_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_RESOURCE, UsageResource))
#define USAGE_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_RESOURCE, UsageResourceClass))
#define USAGE_IS_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_RESOURCE))
#define USAGE_IS_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_RESOURCE))
#define USAGE_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_RESOURCE, UsageResourceClass))

typedef struct _UsageResource UsageResource;
typedef struct _UsageResourceClass UsageResourceClass;
typedef struct _UsageResourcePrivate UsageResourcePrivate;

#define USAGE_TYPE_RESOURCE_COMMAND (usage_resource_command_get_type ())
#define USAGE_RESOURCE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_RESOURCE_COMMAND, UsageResourceCommand))
#define USAGE_RESOURCE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_RESOURCE_COMMAND, UsageResourceCommandClass))
#define USAGE_IS_RESOURCE_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_RESOURCE_COMMAND))
#define USAGE_IS_RESOURCE_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_RESOURCE_COMMAND))
#define USAGE_RESOURCE_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_RESOURCE_COMMAND, UsageResourceCommandClass))

typedef struct _UsageResourceCommand UsageResourceCommand;
typedef struct _UsageResourceCommandClass UsageResourceCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _usage_resource_syncDependenciesData usage_resource_syncDependenciesData;

#define USAGE_TYPE_CONTROLLER (usage_controller_get_type ())
#define USAGE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CONTROLLER, UsageController))
#define USAGE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CONTROLLER, UsageControllerClass))
#define USAGE_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CONTROLLER))
#define USAGE_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CONTROLLER))
#define USAGE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CONTROLLER, UsageControllerClass))

typedef struct _UsageController UsageController;
typedef struct _UsageControllerClass UsageControllerClass;
typedef struct _usage_resource_setPolicyData usage_resource_setPolicyData;
typedef struct _usage_resource_addUserData usage_resource_addUserData;
typedef struct _usage_resource_delUserData usage_resource_delUserData;
typedef struct _usage_resource_enableShadowResourceData usage_resource_enableShadowResourceData;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _UsageResourceEnableData UsageResourceEnableData;
typedef struct _UsageResourceDisableData UsageResourceDisableData;
typedef struct _UsageResourceSuspendData UsageResourceSuspendData;
typedef struct _UsageResourceResumeData UsageResourceResumeData;

struct _UsageIResourceIface {
	GTypeInterface parent_iface;
	void (*setPolicy) (UsageIResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*setPolicy_finish) (UsageIResource* self, GAsyncResult* _res_, GError** error);
	void (*enable) (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*enable_finish) (UsageIResource* self, GAsyncResult* _res_, GError** error);
	void (*disable) (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disable_finish) (UsageIResource* self, GAsyncResult* _res_, GError** error);
	void (*suspend) (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*suspend_finish) (UsageIResource* self, GAsyncResult* _res_, GError** error);
	void (*resume) (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*resume_finish) (UsageIResource* self, GAsyncResult* _res_, GError** error);
};

struct _UsageResource {
	GObject parent_instance;
	UsageResourcePrivate * priv;
	FreeSmartphoneResource* proxy;
	GeeLinkedList* q;
};

struct _UsageResourceClass {
	GObjectClass parent_class;
	void (*setPolicy) (UsageResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*setPolicy_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
	void (*enableShadowResource) (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*enableShadowResource_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
	void (*enable) (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*enable_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
	void (*disable) (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disable_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
	void (*suspend) (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*suspend_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
	void (*resume) (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*resume_finish) (UsageResource* self, GAsyncResult* _res_, GError** error);
};

struct _UsageResourcePrivate {
	gchar* _name;
	char* _busname;
	char* _objectpath;
	FsoFrameworkResourceStatus _status;
	FreeSmartphoneUsageResourcePolicy _policy;
	GeeArrayList* _users;
	GeeArrayList* _processDependencies;
	GeeArrayList* _busDependencies;
};

struct _usage_resource_syncDependenciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	FreeSmartphoneResource* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* dependenciesFromResource;
	GHashTable* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GHashTable* _tmp9_;
	gconstpointer _tmp10_;
	GVariant* _tmp11_;
	GVariant* services;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* servicesStr;
	const gchar* _tmp16_;
	FsoFrameworkLogger* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar** service_collection;
	gint service_collection_length1;
	gint _service_collection_size_;
	gint service_it;
	gchar* _tmp29_;
	gchar* service;
	GeeArrayList* _tmp30_;
	const gchar* _tmp31_;
	FsoFrameworkLogger* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_;
	GError* _error_;
	FsoFrameworkLogger* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError * _inner_error_;
};

struct _usage_resource_setPolicyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	FreeSmartphoneUsageResourcePolicy policy;
	FreeSmartphoneUsageResourcePolicy _tmp0_;
	FreeSmartphoneUsageResourcePolicy _tmp1_;
	FreeSmartphoneUsageResourcePolicy _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FreeSmartphoneUsageResourcePolicy _tmp6_;
	GEnumValue* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	FreeSmartphoneUsageResourcePolicy _tmp11_;
	FreeSmartphoneUsageResourcePolicy _tmp12_;
	FreeSmartphoneUsageResourcePolicy _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	FsoFrameworkLogger* _tmp17_;
	GError * _inner_error_;
};

struct _usage_resource_addUserData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	gchar* user;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	FreeSmartphoneUsageResourcePolicy _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GeeArrayList* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	FreeSmartphoneUsageResourcePolicy _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp27_;
	GError* _error_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _tmp35_;
	GError* _tmp36_;
	GError * _inner_error_;
};

struct _usage_resource_delUserData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	gchar* user;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GeeArrayList* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	FreeSmartphoneUsageResourcePolicy _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_;
	GError * _inner_error_;
};

struct _usage_resource_enableShadowResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	UsageController* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	const char* _tmp7_;
	DBusServiceIPeer* _tmp8_;
	DBusServiceIPeer* service;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	UsageResource * self;
	gpointer _async_data_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint retries;
};

struct _UsageResourceEnableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	Block1Data* _data1_;
	const char* _tmp0_;
	Block2Data* _data2_;
	FreeSmartphoneResource* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	FreeSmartphoneResource* _tmp8_;
	UsageController* _tmp9_;
	FsoFrameworkLogger* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	GError* e;
	UsageController* _tmp16_;
	FsoFrameworkLogger* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	FreeSmartphoneResource* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	GError * _inner_error_;
};

struct _UsageResourceDisableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	const char* _tmp0_;
	FreeSmartphoneResource* _tmp1_;
	UsageController* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError* e;
	UsageController* _tmp9_;
	FsoFrameworkLogger* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _UsageResourceSuspendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	FsoFrameworkResourceStatus _tmp0_;
	FreeSmartphoneResource* _tmp1_;
	UsageController* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError* e;
	UsageController* _tmp9_;
	FsoFrameworkLogger* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FreeSmartphoneResource* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	UsageController* _tmp21_;
	FsoFrameworkLogger* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_;
};

struct _UsageResourceResumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UsageResource* self;
	FsoFrameworkResourceStatus _tmp0_;
	FreeSmartphoneResource* _tmp1_;
	UsageController* _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError* e;
	UsageController* _tmp9_;
	FsoFrameworkLogger* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FreeSmartphoneResource* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	UsageController* _tmp21_;
	FsoFrameworkLogger* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_;
};


static GType usage_iresource_type_id = 0;
static gpointer usage_resource_parent_class = NULL;
extern UsageController* usage_instance;
static UsageIResourceIface* usage_resource_usage_iresource_parent_iface = NULL;
static GType usage_resource_type_id = 0;

GType usage_iresource_get_type (void) G_GNUC_CONST;
GType usage_iresource_register_type (GTypeModule * module);
void usage_iresource_setPolicy (UsageIResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_iresource_setPolicy_finish (UsageIResource* self, GAsyncResult* _res_, GError** error);
void usage_iresource_enable (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_iresource_enable_finish (UsageIResource* self, GAsyncResult* _res_, GError** error);
void usage_iresource_disable (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_iresource_disable_finish (UsageIResource* self, GAsyncResult* _res_, GError** error);
void usage_iresource_suspend (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_iresource_suspend_finish (UsageIResource* self, GAsyncResult* _res_, GError** error);
void usage_iresource_resume (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_iresource_resume_finish (UsageIResource* self, GAsyncResult* _res_, GError** error);
GType usage_resource_get_type (void) G_GNUC_CONST;
GType usage_resource_register_type (GTypeModule * module);
gpointer usage_resource_command_ref (gpointer instance);
void usage_resource_command_unref (gpointer instance);
GParamSpec* usage_param_spec_resource_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void usage_value_set_resource_command (GValue* value, gpointer v_object);
void usage_value_take_resource_command (GValue* value, gpointer v_object);
gpointer usage_value_get_resource_command (const GValue* value);
GType usage_resource_command_get_type (void) G_GNUC_CONST;
GType usage_resource_command_register_type (GTypeModule * module);
#define USAGE_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), USAGE_TYPE_RESOURCE, UsageResourcePrivate))
enum  {
	USAGE_RESOURCE_DUMMY_PROPERTY,
	USAGE_RESOURCE_NAME,
	USAGE_RESOURCE_BUSNAME,
	USAGE_RESOURCE_OBJECTPATH,
	USAGE_RESOURCE_STATUS,
	USAGE_RESOURCE_POLICY,
	USAGE_RESOURCE_USERS,
	USAGE_RESOURCE_PROCESS_DEPENDENCIES,
	USAGE_RESOURCE_BUS_DEPENDENCIES
};
const gchar* usage_resource_get_name (UsageResource* self);
const char* usage_resource_get_busname (UsageResource* self);
const char* usage_resource_get_objectpath (UsageResource* self);
UsageResource* usage_resource_new (const gchar* name, const char* busname, const char* objectpath);
UsageResource* usage_resource_construct (GType object_type, const gchar* name, const char* busname, const char* objectpath);
void usage_resource_set_users (UsageResource* self, GeeArrayList* value);
void usage_resource_set_name (UsageResource* self, const gchar* value);
void usage_resource_set_busname (UsageResource* self, const char* value);
void usage_resource_set_objectpath (UsageResource* self, const char* value);
void usage_resource_set_status (UsageResource* self, FsoFrameworkResourceStatus value);
void usage_resource_set_policy (UsageResource* self, FreeSmartphoneUsageResourcePolicy value);
void usage_resource_set_busDependencies (UsageResource* self, GeeArrayList* value);
static void usage_resource_syncDependencies (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void usage_resource_syncDependencies_finish (UsageResource* self, GAsyncResult* _res_);
static void usage_resource_syncDependencies_data_free (gpointer _data);
static gboolean usage_resource_syncDependencies_co (usage_resource_syncDependenciesData* _data_);
static void usage_resource_syncDependencies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static const gchar* _variant_get1 (GVariant* value);
GeeArrayList* usage_resource_get_busDependencies (UsageResource* self);
static void usage_resource_updateStatus (UsageResource* self);
GeeArrayList* usage_resource_get_users (UsageResource* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
FreeSmartphoneUsageResourcePolicy usage_resource_get_policy (UsageResource* self);
static GVariant* _variant_new2 (FreeSmartphoneUsageResourcePolicy value);
static GVariant* _variant_new3 (gint value);
GType usage_controller_get_type (void) G_GNUC_CONST;
GType usage_controller_register_type (GTypeModule * module);
guint usage_controller_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gboolean usage_resource_isEnabled (UsageResource* self);
FsoFrameworkResourceStatus usage_resource_get_status (UsageResource* self);
gboolean usage_resource_hasUser (UsageResource* self, const gchar* user);
static void usage_resource_real_setPolicy_data_free (gpointer _data);
static void usage_resource_real_setPolicy (UsageResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_setPolicy (UsageResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_setPolicy_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_real_setPolicy_co (usage_resource_setPolicyData* _data_);
const gchar* free_smartphone_usage_resource_policy_to_string (FreeSmartphoneUsageResourcePolicy self);
void usage_resource_disable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_disable_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static void usage_resource_setPolicy_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void usage_resource_enable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_enable_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static void usage_resource_addUser_data_free (gpointer _data);
void usage_resource_addUser (UsageResource* self, const gchar* user, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_addUser_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_addUser_co (usage_resource_addUserData* _data_);
static void usage_resource_addUser_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void usage_resource_delUser_data_free (gpointer _data);
void usage_resource_delUser (UsageResource* self, const gchar* user, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_delUser_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_delUser_co (usage_resource_delUserData* _data_);
static void usage_resource_delUser_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void usage_resource_syncUsers (UsageResource* self);
gchar** usage_resource_allUsers (UsageResource* self, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
gboolean usage_resource_isPresent (UsageResource* self);
static void usage_resource_real_enableShadowResource_data_free (gpointer _data);
static void usage_resource_real_enableShadowResource (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_enableShadowResource (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_enableShadowResource_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_real_enableShadowResource_co (usage_resource_enableShadowResourceData* _data_);
static void usage_resource_real_enable_data_free (gpointer _data);
static void usage_resource_real_enable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean usage_resource_real_enable_co (UsageResourceEnableData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void usage_resource_enable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean ___lambda1_ (Block2Data* _data2_);
static gboolean ____lambda1__gsource_func (gpointer self);
static void usage_resource_real_disable_data_free (gpointer _data);
static void usage_resource_real_disable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean usage_resource_real_disable_co (UsageResourceDisableData* _data_);
static void usage_resource_disable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void usage_resource_real_suspend_data_free (gpointer _data);
static void usage_resource_real_suspend (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_suspend (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_suspend_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_real_suspend_co (UsageResourceSuspendData* _data_);
static void usage_resource_suspend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void usage_resource_real_resume_data_free (gpointer _data);
static void usage_resource_real_resume (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_resume (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void usage_resource_resume_finish (UsageResource* self, GAsyncResult* _res_, GError** error);
static gboolean usage_resource_real_resume_co (UsageResourceResumeData* _data_);
static void usage_resource_resume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* usage_resource_get_processDependencies (UsageResource* self);
void usage_resource_set_processDependencies (UsageResource* self, GeeArrayList* value);
static void usage_resource_finalize (GObject* obj);
static void _vala_usage_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_usage_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void usage_iresource_setPolicy (UsageIResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->setPolicy (self, policy, _callback_, _user_data_);
}


void usage_iresource_setPolicy_finish (UsageIResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->setPolicy_finish (self, _res_, error);
}


void usage_iresource_enable (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->enable (self, _callback_, _user_data_);
}


void usage_iresource_enable_finish (UsageIResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->enable_finish (self, _res_, error);
}


void usage_iresource_disable (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->disable (self, _callback_, _user_data_);
}


void usage_iresource_disable_finish (UsageIResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->disable_finish (self, _res_, error);
}


void usage_iresource_suspend (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->suspend (self, _callback_, _user_data_);
}


void usage_iresource_suspend_finish (UsageIResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->suspend_finish (self, _res_, error);
}


void usage_iresource_resume (UsageIResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->resume (self, _callback_, _user_data_);
}


void usage_iresource_resume_finish (UsageIResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_IRESOURCE_GET_INTERFACE (self)->resume_finish (self, _res_, error);
}


static void usage_iresource_base_init (UsageIResourceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * @interface IResource
 **/
GType usage_iresource_get_type (void) {
	return usage_iresource_type_id;
}


GType usage_iresource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (UsageIResourceIface), (GBaseInitFunc) usage_iresource_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	usage_iresource_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "UsageIResource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (usage_iresource_type_id, G_TYPE_OBJECT);
	return usage_iresource_type_id;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


UsageResource* usage_resource_construct (GType object_type, const gchar* name, const char* busname, const char* objectpath) {
	UsageResource * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeLinkedList* _tmp2_;
	const gchar* _tmp3_;
	const char* _tmp4_;
	const char* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	const char* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (busname != NULL, NULL);
	self = (UsageResource*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_tmp1_ = _tmp0_;
	usage_resource_set_users (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gee_linked_list_new (USAGE_TYPE_RESOURCE_COMMAND, NULL, NULL, NULL);
	_g_object_unref0 (self->q);
	self->q = _tmp2_;
	_tmp3_ = name;
	usage_resource_set_name (self, _tmp3_);
	_tmp4_ = busname;
	usage_resource_set_busname (self, _tmp4_);
	_tmp5_ = objectpath;
	usage_resource_set_objectpath (self, _tmp5_);
	usage_resource_set_status (self, FSO_FRAMEWORK_RESOURCE_STATUS_UNKNOWN);
	usage_resource_set_policy (self, FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_AUTO);
	_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_tmp7_ = _tmp6_;
	usage_resource_set_busDependencies (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = objectpath;
	if (_tmp8_ != NULL) {
		const char* _tmp9_;
		const char* _tmp10_;
		FreeSmartphoneResource* _tmp11_ = NULL;
		FreeSmartphoneResource* _tmp12_;
		FsoFrameworkLogger* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		const char* _tmp16_;
		const gchar* _tmp17_ = NULL;
		const char* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp9_ = busname;
		_tmp10_ = objectpath;
		_tmp11_ = g_initable_new (FREE_SMARTPHONE_TYPE_RESOURCE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", (const gchar*) _tmp9_, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _tmp10_, "g-interface-name", "org.freesmartphone.Resource", NULL);
		_tmp12_ = (FreeSmartphoneResource*) _tmp11_;
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->proxy);
		self->proxy = _tmp12_;
		_tmp13_ = fso_framework_theLogger;
		_tmp14_ = name;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = busname;
		_tmp17_ = string_to_string ((const gchar*) _tmp16_);
		_tmp18_ = objectpath;
		_tmp19_ = string_to_string ((const gchar*) _tmp18_);
		_tmp20_ = g_strconcat ("Resource ", _tmp15_, " served by ", _tmp17_, " (", _tmp19_, ") created", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = fso_framework_logger_debug (_tmp13_, _tmp21_);
		g_assert (_tmp22_);
		_g_free0 (_tmp21_);
		usage_resource_syncDependencies (self, NULL, NULL);
	} else {
		FsoFrameworkLogger* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		const char* _tmp26_;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		_tmp23_ = fso_framework_theLogger;
		_tmp24_ = name;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = busname;
		_tmp27_ = string_to_string ((const gchar*) _tmp26_);
		_tmp28_ = g_strconcat ("Shadow Resource ", _tmp25_, " served by ", _tmp27_, " (unknown objectpath) created", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = fso_framework_logger_debug (_tmp23_, _tmp29_);
		g_assert (_tmp30_);
		_g_free0 (_tmp29_);
	}
	return self;
}


UsageResource* usage_resource_new (const gchar* name, const char* busname, const char* objectpath) {
	return usage_resource_construct (USAGE_TYPE_RESOURCE, name, busname, objectpath);
}


static void usage_resource_syncDependencies_data_free (gpointer _data) {
	usage_resource_syncDependenciesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (usage_resource_syncDependenciesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void usage_resource_syncDependencies (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	usage_resource_syncDependenciesData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (usage_resource_syncDependenciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_syncDependencies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_syncDependencies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_syncDependencies_co (_data_);
}


static void usage_resource_syncDependencies_finish (UsageResource* self, GAsyncResult* _res_) {
	usage_resource_syncDependenciesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Sync dependencies of the resource with our local list.
     **/
static void usage_resource_syncDependencies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	usage_resource_syncDependenciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_syncDependencies_co (_data_);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static const gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gboolean usage_resource_syncDependencies_co (usage_resource_syncDependenciesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->proxy;
		_data_->_state_ = 1;
		free_smartphone_resource_get_dependencies (_data_->_tmp0_, usage_resource_syncDependencies_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = free_smartphone_resource_get_dependencies_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->dependenciesFromResource = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->dependenciesFromResource;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp3_ = fso_framework_theLogger;
			_data_->_tmp4_ = _data_->self->priv->_name;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_strconcat ("There are no dependencies for resource '", _data_->_tmp5_, "'.", NULL);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = fso_framework_logger_debug (_data_->_tmp3_, _data_->_tmp7_);
			g_assert (_data_->_tmp8_);
			_g_free0 (_data_->_tmp7_);
			_g_hash_table_unref0 (_data_->dependenciesFromResource);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = _data_->dependenciesFromResource;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_hash_table_lookup (_data_->_tmp9_, "services");
		_data_->_tmp11_ = _g_variant_ref0 ((GVariant*) _data_->_tmp10_);
		_data_->services = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->services;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->services;
			_data_->_tmp14_ = _variant_get1 (_data_->_tmp13_);
			_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
			_data_->servicesStr = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->servicesStr;
			if (_data_->_tmp16_ != NULL) {
				_data_->_tmp17_ = fso_framework_theLogger;
				_data_->_tmp18_ = _data_->self->priv->_name;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = string_to_string (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->servicesStr;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = string_to_string (_data_->_tmp20_);
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = g_strconcat ("Resource '", _data_->_tmp19_, "' has the following dependencies: ", _data_->_tmp21_, NULL);
				_data_->_tmp23_ = _data_->_tmp22_;
				_data_->_tmp24_ = FALSE;
				_data_->_tmp24_ = fso_framework_logger_debug (_data_->_tmp17_, _data_->_tmp23_);
				g_assert (_data_->_tmp24_);
				_g_free0 (_data_->_tmp23_);
				_data_->_tmp25_ = _data_->servicesStr;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->_tmp26_ = g_strsplit (_data_->_tmp25_, ",", 0);
				_data_->parts = _data_->_tmp27_;
				_data_->parts_length1 = _vala_array_length (_data_->_tmp26_);
				_data_->_parts_size_ = _data_->parts_length1;
				_data_->_tmp28_ = _data_->parts;
				_data_->_tmp28__length1 = _data_->parts_length1;
				{
					_data_->service_collection_length1 = 0;
					_data_->_service_collection_size_ = 0;
					_data_->service_collection = _data_->_tmp28_;
					_data_->service_collection_length1 = _data_->_tmp28__length1;
					_data_->service_it = 0;
					for (_data_->service_it = 0; _data_->service_it < _data_->_tmp28__length1; _data_->service_it = _data_->service_it + 1) {
						_data_->_tmp29_ = g_strdup (_data_->service_collection[_data_->service_it]);
						_data_->service = _data_->_tmp29_;
						{
							_data_->_tmp30_ = _data_->self->priv->_busDependencies;
							_data_->_tmp31_ = _data_->service;
							gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp30_, _data_->_tmp31_);
							_g_free0 (_data_->service);
						}
					}
				}
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (_data_->servicesStr);
		} else {
			_data_->_tmp32_ = fso_framework_theLogger;
			_data_->_tmp33_ = _data_->self->priv->_name;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = string_to_string (_data_->_tmp33_);
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = g_strconcat ("Resource '", _data_->_tmp34_, "' does not has any dependencies.", NULL);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = FALSE;
			_data_->_tmp37_ = fso_framework_logger_debug (_data_->_tmp32_, _data_->_tmp36_);
			g_assert (_data_->_tmp37_);
			_g_free0 (_data_->_tmp36_);
		}
		_g_variant_unref0 (_data_->services);
		_g_hash_table_unref0 (_data_->dependenciesFromResource);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp38_ = fso_framework_theLogger;
		_data_->_tmp39_ = _data_->self->priv->_name;
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = string_to_string (_data_->_tmp39_);
		_data_->_tmp41_ = _data_->_error_;
		_data_->_tmp42_ = _data_->_tmp41_->message;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = string_to_string (_data_->_tmp42_);
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = g_strconcat ("Can't sync dependencies of resource '", _data_->_tmp40_, "': ", _data_->_tmp43_, NULL);
		_data_->_tmp45_ = _data_->_tmp44_;
		fso_framework_logger_error (_data_->_tmp38_, _data_->_tmp45_);
		_g_free0 (_data_->_tmp45_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant* _variant_new2 (FreeSmartphoneUsageResourcePolicy value) {
	return g_variant_ref_sink (g_variant_new_string (free_smartphone_usage_resource_policy_to_string (value)));
}


static GVariant* _variant_new3 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static void usage_resource_updateStatus (UsageResource* self) {
	GeeArrayList* _tmp0_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* info;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	FreeSmartphoneUsageResourcePolicy _tmp11_;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GVariant* _tmp18_;
	UsageController* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GHashTable* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_users;
	if (_tmp0_ == NULL) {
		FsoFrameworkLogger* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = fso_framework_theLogger;
		_tmp2_ = self->priv->_name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Resource ", _tmp3_, " already destroyed.", NULL);
		_tmp5_ = _tmp4_;
		fso_framework_logger_warning (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		return;
	}
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, _g_variant_unref0_);
	info = _tmp8_;
	_tmp9_ = info;
	_tmp10_ = g_strdup ("policy");
	_tmp11_ = self->priv->_policy;
	_tmp12_ = _variant_new2 (_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	_tmp13_ = info;
	_tmp14_ = g_strdup ("refcount");
	_tmp15_ = self->priv->_users;
	_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _variant_new3 (_tmp17_);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp18_);
	_tmp19_ = usage_instance;
	_tmp20_ = self->priv->_name;
	_tmp21_ = usage_resource_isEnabled (self);
	_tmp22_ = info;
	g_signal_emit_by_name (_tmp19_, "resource-changed", _tmp20_, _tmp21_, _tmp22_);
	_g_hash_table_unref0 (info);
}


gboolean usage_resource_isEnabled (UsageResource* self) {
	gboolean result = FALSE;
	FsoFrameworkResourceStatus _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_status;
	result = _tmp0_ == FSO_FRAMEWORK_RESOURCE_STATUS_ENABLED;
	return result;
}


gboolean usage_resource_hasUser (UsageResource* self, const gchar* user) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (user != NULL, FALSE);
	_tmp0_ = self->priv->_users;
	_tmp1_ = user;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void usage_resource_real_setPolicy_data_free (gpointer _data) {
	usage_resource_setPolicyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (usage_resource_setPolicyData, _data_);
}


static void usage_resource_real_setPolicy (UsageResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	usage_resource_setPolicyData* _data_;
	UsageResource* _tmp0_;
	FreeSmartphoneUsageResourcePolicy _tmp1_;
	_data_ = g_slice_new0 (usage_resource_setPolicyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_setPolicy);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_setPolicy_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = policy;
	_data_->policy = _tmp1_;
	usage_resource_real_setPolicy_co (_data_);
}


static void usage_resource_real_setPolicy_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	usage_resource_setPolicyData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_setPolicy_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	usage_resource_setPolicyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_real_setPolicy_co (_data_);
}


static gboolean usage_resource_real_setPolicy_co (usage_resource_setPolicyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->policy;
	_data_->_tmp1_ = _data_->self->priv->_policy;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp2_ = _data_->policy;
		usage_resource_set_policy (_data_->self, _data_->_tmp2_);
	}
	_data_->_tmp3_ = fso_framework_theLogger;
	_data_->_tmp4_ = _data_->self->priv->_name;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->policy;
	_data_->_tmp7_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_TYPE_USAGE_RESOURCE_POLICY), _data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strconcat ("Policy for resource '", _data_->_tmp5_, "' is now ", (_data_->_tmp7_ != NULL) ? _data_->_tmp7_->value_name : NULL, NULL);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = FALSE;
	_data_->_tmp10_ = fso_framework_logger_debug (_data_->_tmp3_, _data_->_tmp9_);
	g_assert (_data_->_tmp10_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->policy;
	if (_data_->_tmp11_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_DISABLED) {
		_data_->_state_ = 1;
		usage_resource_disable (_data_->self, usage_resource_setPolicy_ready, _data_);
		return FALSE;
		_state_1:
		usage_resource_disable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp12_ = _data_->policy;
		if (_data_->_tmp12_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_ENABLED) {
			_data_->_state_ = 2;
			usage_resource_enable (_data_->self, usage_resource_setPolicy_ready, _data_);
			return FALSE;
			_state_2:
			usage_resource_enable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
		} else {
			_data_->_tmp13_ = _data_->policy;
			if (_data_->_tmp13_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_AUTO) {
				_data_->_tmp14_ = _data_->self->priv->_users;
				_data_->_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				if (_data_->_tmp16_ > 0) {
					_data_->_state_ = 3;
					usage_resource_enable (_data_->self, usage_resource_setPolicy_ready, _data_);
					return FALSE;
					_state_3:
					usage_resource_enable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
							g_error_free (_data_->_inner_error_);
							if (_data_->_state_ == 0) {
								g_simple_async_result_complete_in_idle (_data_->_async_result);
							} else {
								g_simple_async_result_complete (_data_->_async_result);
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
							g_clear_error (&_data_->_inner_error_);
							return FALSE;
						}
					}
				} else {
					_data_->_state_ = 4;
					usage_resource_disable (_data_->self, usage_resource_setPolicy_ready, _data_);
					return FALSE;
					_state_4:
					usage_resource_disable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
							g_error_free (_data_->_inner_error_);
							if (_data_->_state_ == 0) {
								g_simple_async_result_complete_in_idle (_data_->_async_result);
							} else {
								g_simple_async_result_complete (_data_->_async_result);
							}
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
							g_clear_error (&_data_->_inner_error_);
							return FALSE;
						}
					}
				}
			} else {
				_data_->_tmp17_ = fso_framework_theLogger;
				fso_framework_logger_error (_data_->_tmp17_, "Unknown usage resouce policy. Ignoring");
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_setPolicy (UsageResource* self, FreeSmartphoneUsageResourcePolicy policy, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->setPolicy (self, policy, _callback_, _user_data_);
}


void usage_resource_setPolicy_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->setPolicy_finish (self, _res_, error);
}


static void usage_resource_addUser_data_free (gpointer _data) {
	usage_resource_addUserData* _data_;
	_data_ = _data;
	_g_free0 (_data_->user);
	_g_object_unref0 (_data_->self);
	g_slice_free (usage_resource_addUserData, _data_);
}


void usage_resource_addUser (UsageResource* self, const gchar* user, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	usage_resource_addUserData* _data_;
	UsageResource* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (usage_resource_addUserData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_addUser);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_addUser_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->user = _tmp2_;
	usage_resource_addUser_co (_data_);
}


void usage_resource_addUser_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	usage_resource_addUserData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_addUser_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	usage_resource_addUserData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_addUser_co (_data_);
}


static gboolean usage_resource_addUser_co (usage_resource_addUserData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_users;
	_data_->_tmp1_ = _data_->user;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->_name;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->user;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Resource ", _data_->_tmp4_, " already requested by user ", _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new_literal (FREE_SMARTPHONE_USAGE_ERROR, FREE_SMARTPHONE_USAGE_ERROR_USER_EXISTS, _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_free0 (_data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_USAGE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = _data_->self->priv->_policy;
	if (_data_->_tmp11_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_DISABLED) {
		_data_->_tmp12_ = _data_->self->priv->_name;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = string_to_string (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->user;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = string_to_string (_data_->_tmp14_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_strconcat ("Resource ", _data_->_tmp13_, " cannot be requested by ", _data_->_tmp15_, " per policy", NULL);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = g_error_new_literal (FREE_SMARTPHONE_USAGE_ERROR, FREE_SMARTPHONE_USAGE_ERROR_POLICY_DISABLED, _data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_g_free0 (_data_->_tmp17_);
		_data_->_inner_error_ = _data_->_tmp19_;
		if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_USAGE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp20_ = _data_->self->priv->_users;
	_data_->_tmp21_ = _data_->user;
	gee_abstract_list_insert ((GeeAbstractList*) _data_->_tmp20_, 0, _data_->_tmp21_);
	_data_->_tmp23_ = _data_->self->priv->_policy;
	if (_data_->_tmp23_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_AUTO) {
		_data_->_tmp24_ = _data_->self->priv->_users;
		_data_->_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp22_ = _data_->_tmp26_ == 1;
	} else {
		_data_->_tmp22_ = FALSE;
	}
	_data_->_tmp27_ = _data_->_tmp22_;
	if (_data_->_tmp27_) {
		{
			_data_->_state_ = 1;
			usage_resource_enable (_data_->self, usage_resource_addUser_ready, _data_);
			return FALSE;
			_state_1:
			usage_resource_enable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp28_ = _data_->self->priv->_name;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = string_to_string (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_error_;
			_data_->_tmp31_ = _data_->_tmp30_->message;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = string_to_string (_data_->_tmp31_);
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = g_strconcat ("Could not enable resource '", _data_->_tmp29_, "': ", _data_->_tmp32_, NULL);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = g_error_new_literal (FREE_SMARTPHONE_RESOURCE_ERROR, FREE_SMARTPHONE_RESOURCE_ERROR_UNABLE_TO_ENABLE, _data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_g_free0 (_data_->_tmp34_);
			_data_->_inner_error_ = _data_->_tmp36_;
			_g_error_free0 (_data_->_error_);
			goto __finally1;
		}
		__finally1:
		if (_data_->_inner_error_ != NULL) {
			if ((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == FREE_SMARTPHONE_USAGE_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		usage_resource_updateStatus (_data_->self);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void usage_resource_delUser_data_free (gpointer _data) {
	usage_resource_delUserData* _data_;
	_data_ = _data;
	_g_free0 (_data_->user);
	_g_object_unref0 (_data_->self);
	g_slice_free (usage_resource_delUserData, _data_);
}


void usage_resource_delUser (UsageResource* self, const gchar* user, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	usage_resource_delUserData* _data_;
	UsageResource* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (usage_resource_delUserData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_delUser);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_delUser_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->user = _tmp2_;
	usage_resource_delUser_co (_data_);
}


void usage_resource_delUser_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	usage_resource_delUserData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_delUser_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	usage_resource_delUserData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_delUser_co (_data_);
}


static gboolean usage_resource_delUser_co (usage_resource_delUserData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_users;
	_data_->_tmp1_ = _data_->user;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp0_, _data_->_tmp1_);
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->_name;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->user;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Resource ", _data_->_tmp4_, " never been requested by user ", _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new_literal (FREE_SMARTPHONE_USAGE_ERROR, FREE_SMARTPHONE_USAGE_ERROR_USER_UNKNOWN, _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_free0 (_data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if (_data_->_inner_error_->domain == FREE_SMARTPHONE_USAGE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = _data_->self->priv->_users;
	_data_->_tmp12_ = _data_->user;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp11_, _data_->_tmp12_);
	_data_->_tmp14_ = _data_->self->priv->_policy;
	if (_data_->_tmp14_ == FREE_SMARTPHONE_USAGE_RESOURCE_POLICY_AUTO) {
		_data_->_tmp15_ = _data_->self->priv->_users;
		_data_->_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp13_ = _data_->_tmp17_ == 0;
	} else {
		_data_->_tmp13_ = FALSE;
	}
	_data_->_tmp18_ = _data_->_tmp13_;
	if (_data_->_tmp18_) {
		_data_->_state_ = 1;
		usage_resource_disable (_data_->self, usage_resource_delUser_ready, _data_);
		return FALSE;
		_state_1:
		usage_resource_disable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FREE_SMARTPHONE_USAGE_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		usage_resource_updateStatus (_data_->self);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_syncUsers (UsageResource* self) {
	DBusServiceIDBusSync* _tmp0_ = NULL;
	DBusServiceIDBusSync* busobj;
	DBusServiceIDBusSync* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** busnames;
	gint busnames_length1;
	gint _busnames_size_;
	GeeArrayList* _tmp4_;
	GeeArrayList* usersToRemove;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_initable_new (DBUS_SERVICE_TYPE_ID_BUS_SYNC_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", DBUS_SERVICE_DBUS_SERVICE_DBUS, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", DBUS_SERVICE_DBUS_PATH_DBUS, "g-interface-name", "org.freedesktop.DBus", NULL);
	busobj = (DBusServiceIDBusSync*) _tmp0_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = busobj;
	_tmp3_ = dbus_service_id_bus_sync_ListNames (_tmp1_, &_tmp2_, &_inner_error_);
	busnames = _tmp3_;
	busnames_length1 = _tmp2_;
	_busnames_size_ = busnames_length1;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (busobj);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	usersToRemove = _tmp4_;
	{
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _userbusname_list;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _userbusname_size;
		gint _userbusname_index;
		_tmp5_ = self->priv->_users;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_userbusname_list = _tmp6_;
		_tmp7_ = _userbusname_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_userbusname_size = _tmp9_;
		_userbusname_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_ = NULL;
			gchar* userbusname;
			gboolean found;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gboolean _tmp20_;
			_tmp10_ = _userbusname_index;
			_userbusname_index = _tmp10_ + 1;
			_tmp11_ = _userbusname_index;
			_tmp12_ = _userbusname_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _userbusname_list;
			_tmp14_ = _userbusname_index;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			userbusname = (gchar*) _tmp15_;
			found = FALSE;
			_tmp16_ = busnames;
			_tmp16__length1 = busnames_length1;
			{
				gchar** busname_collection = NULL;
				gint busname_collection_length1 = 0;
				gint _busname_collection_size_ = 0;
				gint busname_it = 0;
				busname_collection = _tmp16_;
				busname_collection_length1 = _tmp16__length1;
				for (busname_it = 0; busname_it < _tmp16__length1; busname_it = busname_it + 1) {
					gchar* _tmp17_;
					gchar* busname = NULL;
					_tmp17_ = g_strdup (busname_collection[busname_it]);
					busname = _tmp17_;
					{
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						_tmp18_ = userbusname;
						_tmp19_ = busname;
						if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
							found = TRUE;
						}
						_g_free0 (busname);
						break;
					}
				}
			}
			_tmp20_ = found;
			if (!_tmp20_) {
				GeeArrayList* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = usersToRemove;
				_tmp22_ = userbusname;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
			}
			_g_free0 (userbusname);
		}
		_g_object_unref0 (_userbusname_list);
	}
	{
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		GeeArrayList* _userbusname_list;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _userbusname_size;
		gint _userbusname_index;
		_tmp23_ = usersToRemove;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_userbusname_list = _tmp24_;
		_tmp25_ = _userbusname_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_userbusname_size = _tmp27_;
		_userbusname_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* userbusname;
			UsageController* _tmp34_;
			FsoFrameworkLogger* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp28_ = _userbusname_index;
			_userbusname_index = _tmp28_ + 1;
			_tmp29_ = _userbusname_index;
			_tmp30_ = _userbusname_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _userbusname_list;
			_tmp32_ = _userbusname_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			userbusname = (gchar*) _tmp33_;
			_tmp34_ = usage_instance;
			_tmp35_ = ((FsoFrameworkAbstractObject*) _tmp34_)->logger;
			_tmp36_ = self->priv->_name;
			_tmp37_ = string_to_string (_tmp36_);
			_tmp38_ = userbusname;
			_tmp39_ = string_to_string (_tmp38_);
			_tmp40_ = g_strconcat ("Resource ", _tmp37_, " user ", _tmp39_, " has vanished.", NULL);
			_tmp41_ = _tmp40_;
			fso_framework_logger_warning (_tmp35_, _tmp41_);
			_g_free0 (_tmp41_);
			_tmp42_ = userbusname;
			usage_resource_delUser (self, _tmp42_, NULL, NULL);
			_g_free0 (userbusname);
		}
		_g_object_unref0 (_userbusname_list);
	}
	_g_object_unref0 (usersToRemove);
	busnames = (_vala_array_free (busnames, busnames_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (busobj);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** usage_resource_allUsers (UsageResource* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** res;
	gint res_length1;
	gint _res_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	res = _tmp0_;
	res_length1 = 0;
	_res_size_ = res_length1;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _user_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _user_size;
		gint _user_index;
		_tmp1_ = self->priv->_users;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_user_list = _tmp2_;
		_tmp3_ = _user_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_user_size = _tmp5_;
		_user_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* user;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp6_ = _user_index;
			_user_index = _tmp6_ + 1;
			_tmp7_ = _user_index;
			_tmp8_ = _user_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _user_list;
			_tmp10_ = _user_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			user = (gchar*) _tmp11_;
			_tmp12_ = res;
			_tmp12__length1 = res_length1;
			_tmp13_ = user;
			_tmp14_ = g_strdup (_tmp13_);
			_vala_array_add1 (&res, &res_length1, &_res_size_, _tmp14_);
			_g_free0 (user);
		}
		_g_object_unref0 (_user_list);
	}
	_tmp15_ = res;
	_tmp15__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}


gboolean usage_resource_isPresent (UsageResource* self) {
	gboolean result = FALSE;
	const char* _tmp0_;
	const char* _tmp1_;
	DBusServiceIPeer* _tmp2_ = NULL;
	DBusServiceIPeer* peer;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_busname;
	_tmp1_ = self->priv->_objectpath;
	_tmp2_ = g_initable_new (DBUS_SERVICE_TYPE_IPEER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", (const gchar*) _tmp0_, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) _tmp1_, "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
	peer = (DBusServiceIPeer*) _tmp2_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	{
		dbus_service_ipeer_Ping (peer, NULL, NULL);
		result = TRUE;
		_g_object_unref0 (peer);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		UsageController* _tmp3_;
		FsoFrameworkLogger* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = usage_instance;
		_tmp4_ = ((FsoFrameworkAbstractObject*) _tmp3_)->logger;
		_tmp5_ = self->priv->_name;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Resource ", _tmp6_, " incommunicado: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_warning (_tmp4_, _tmp11_);
		_g_free0 (_tmp11_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (peer);
		return result;
	}
	__finally2:
	_g_object_unref0 (peer);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void usage_resource_real_enableShadowResource_data_free (gpointer _data) {
	usage_resource_enableShadowResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (usage_resource_enableShadowResourceData, _data_);
}


static void usage_resource_real_enableShadowResource (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	usage_resource_enableShadowResourceData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (usage_resource_enableShadowResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_enableShadowResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_enableShadowResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_real_enableShadowResource_co (_data_);
}


static void usage_resource_real_enableShadowResource_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	usage_resource_enableShadowResourceData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean usage_resource_real_enableShadowResource_co (usage_resource_enableShadowResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = usage_instance;
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->_tmp0_)->logger;
	_data_->_tmp2_ = _data_->self->priv->_name;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = string_to_string (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strconcat ("Resource ", _data_->_tmp3_, " is shadow resource; pinging...", NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = fso_framework_logger_debug (_data_->_tmp1_, _data_->_tmp5_);
	g_assert (_data_->_tmp6_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->self->priv->_busname;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_initable_new (DBUS_SERVICE_TYPE_IPEER_PROXY, NULL, &_data_->_inner_error_, "g-flags", 0, "g-name", (const gchar*) _data_->_tmp7_, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.freedesktop.DBus.Peer", NULL);
	_data_->service = (DBusServiceIPeer*) _data_->_tmp8_;
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	dbus_service_ipeer_Ping (_data_->service, NULL, NULL);
	_g_object_unref0 (_data_->service);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_enableShadowResource (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->enableShadowResource (self, _callback_, _user_data_);
}


void usage_resource_enableShadowResource_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->enableShadowResource_finish (self, _res_, error);
}


static void usage_resource_real_enable_data_free (gpointer _data) {
	UsageResourceEnableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageResourceEnableData, _data_);
}


static void usage_resource_real_enable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UsageResourceEnableData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (UsageResourceEnableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_enable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_enable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_real_enable_co (_data_);
}


static void usage_resource_real_enable_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	UsageResourceEnableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void usage_resource_enable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UsageResourceEnableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_real_enable_co (_data_);
}


static gboolean ___lambda1_ (Block2Data* _data2_) {
	Block1Data* _data1_;
	UsageResource * self;
	gboolean result = FALSE;
	gint _tmp0_;
	FreeSmartphoneResource* _tmp7_;
	gint _tmp15_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->retries;
	if (_tmp0_ > 10) {
		UsageController* _tmp1_;
		FsoFrameworkLogger* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp1_ = usage_instance;
		_tmp2_ = ((FsoFrameworkAbstractObject*) _tmp1_)->logger;
		_tmp3_ = self->priv->_name;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = g_strconcat ("Can't enable resource '", _tmp4_, "' as it has never registered!", NULL);
		_tmp6_ = _tmp5_;
		fso_framework_logger_error (_tmp2_, _tmp6_);
		_g_free0 (_tmp6_);
		result = FALSE;
		return result;
	}
	_tmp7_ = self->proxy;
	if (_tmp7_ != NULL) {
		UsageController* _tmp8_;
		FsoFrameworkLogger* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp8_ = usage_instance;
		_tmp9_ = ((FsoFrameworkAbstractObject*) _tmp8_)->logger;
		_tmp10_ = self->priv->_name;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat ("DBus proxy for resource '", _tmp11_, "' is now available.", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = fso_framework_logger_debug (_tmp9_, _tmp13_);
		g_assert (_tmp14_);
		_g_free0 (_tmp13_);
		usage_resource_real_enable_co (_data1_->_async_data_);
		result = FALSE;
		return result;
	}
	_tmp15_ = _data2_->retries;
	_data2_->retries = _tmp15_ + 1;
	result = TRUE;
	return result;
}


static gboolean ____lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda1_ (self);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean usage_resource_real_enable_co (UsageResourceEnableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_objectpath;
	if (_data_->_tmp0_ == NULL) {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_state_ = 1;
		usage_resource_enableShadowResource (_data_->self, usage_resource_enable_ready, _data_);
		return FALSE;
		_state_1:
		usage_resource_enableShadowResource_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				block2_data_unref (_data_->_data2_);
				_data_->_data2_ = NULL;
				block1_data_unref (_data_->_data1_);
				_data_->_data1_ = NULL;
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				block2_data_unref (_data_->_data2_);
				_data_->_data2_ = NULL;
				block1_data_unref (_data_->_data1_);
				_data_->_data1_ = NULL;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_data2_->retries = 0;
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda1__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
		_data_->_state_ = 2;
		return FALSE;
		_state_2:
		;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_data_->_tmp1_ = _data_->self->proxy;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = _data_->self->priv->_name;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = string_to_string (_data_->_tmp2_);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_strconcat ("Can't enable resource '", _data_->_tmp3_, "'", NULL);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_error_new_literal (FREE_SMARTPHONE_RESOURCE_ERROR, FREE_SMARTPHONE_RESOURCE_ERROR_UNABLE_TO_ENABLE, _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_free0 (_data_->_tmp5_);
		_data_->_inner_error_ = _data_->_tmp7_;
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp8_ = _data_->self->proxy;
		_data_->_state_ = 3;
		free_smartphone_resource_enable (_data_->_tmp8_, usage_resource_enable_ready, _data_);
		return FALSE;
		_state_3:
		free_smartphone_resource_enable_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_data_->_tmp9_ = usage_instance;
		_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->_tmp9_)->logger;
		_data_->_tmp11_ = _data_->self->priv->_name;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_strconcat ("Enabled resource ", _data_->_tmp12_, " successfully", NULL);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = FALSE;
		_data_->_tmp15_ = fso_framework_logger_debug (_data_->_tmp10_, _data_->_tmp14_);
		g_assert (_data_->_tmp15_);
		_g_free0 (_data_->_tmp14_);
		usage_resource_set_status (_data_->self, FSO_FRAMEWORK_RESOURCE_STATUS_ENABLED);
		usage_resource_updateStatus (_data_->self);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp16_ = usage_instance;
		_data_->_tmp17_ = ((FsoFrameworkAbstractObject*) _data_->_tmp16_)->logger;
		_data_->_tmp18_ = _data_->self->priv->_name;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = string_to_string (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->e;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = string_to_string (_data_->_tmp21_);
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_strconcat ("Resource ", _data_->_tmp19_, " can't be enabled: ", _data_->_tmp22_, ". Trying to disable instead", NULL);
		_data_->_tmp24_ = _data_->_tmp23_;
		fso_framework_logger_error (_data_->_tmp17_, _data_->_tmp24_);
		_g_free0 (_data_->_tmp24_);
		_data_->_tmp25_ = _data_->self->proxy;
		_data_->_state_ = 4;
		free_smartphone_resource_disable (_data_->_tmp25_, usage_resource_enable_ready, _data_);
		return FALSE;
		_state_4:
		free_smartphone_resource_disable_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_g_error_free0 (_data_->e);
			goto __finally3;
		}
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = _g_error_copy0 (_data_->_tmp26_);
		_data_->_inner_error_ = _data_->_tmp27_;
		_g_error_free0 (_data_->e);
		goto __finally3;
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_enable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->enable (self, _callback_, _user_data_);
}


void usage_resource_enable_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->enable_finish (self, _res_, error);
}


static void usage_resource_real_disable_data_free (gpointer _data) {
	UsageResourceDisableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageResourceDisableData, _data_);
}


static void usage_resource_real_disable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UsageResourceDisableData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (UsageResourceDisableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_disable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_disable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_real_disable_co (_data_);
}


static void usage_resource_real_disable_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	UsageResourceDisableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_disable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UsageResourceDisableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_real_disable_co (_data_);
}


static gboolean usage_resource_real_disable_co (UsageResourceDisableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_objectpath;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->proxy;
		_data_->_state_ = 1;
		free_smartphone_resource_disable (_data_->_tmp1_, usage_resource_disable_ready, _data_);
		return FALSE;
		_state_1:
		free_smartphone_resource_disable_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_data_->_tmp2_ = usage_instance;
		_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->_tmp2_)->logger;
		_data_->_tmp4_ = _data_->self->priv->_name;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_strconcat ("Disabled resource ", _data_->_tmp5_, " successfully", NULL);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = fso_framework_logger_debug (_data_->_tmp3_, _data_->_tmp7_);
		g_assert (_data_->_tmp8_);
		_g_free0 (_data_->_tmp7_);
		usage_resource_set_status (_data_->self, FSO_FRAMEWORK_RESOURCE_STATUS_DISABLED);
		usage_resource_updateStatus (_data_->self);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = usage_instance;
		_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->_tmp9_)->logger;
		_data_->_tmp11_ = _data_->self->priv->_name;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = string_to_string (_data_->_tmp14_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_strconcat ("Resource ", _data_->_tmp12_, " can't be disabled: ", _data_->_tmp15_, ". Setting status to UNKNOWN", NULL);
		_data_->_tmp17_ = _data_->_tmp16_;
		fso_framework_logger_error (_data_->_tmp10_, _data_->_tmp17_);
		_g_free0 (_data_->_tmp17_);
		usage_resource_set_status (_data_->self, FSO_FRAMEWORK_RESOURCE_STATUS_UNKNOWN);
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
		_data_->_inner_error_ = _data_->_tmp19_;
		_g_error_free0 (_data_->e);
		goto __finally4;
	}
	__finally4:
	if (_data_->_inner_error_ != NULL) {
		if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_disable (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->disable (self, _callback_, _user_data_);
}


void usage_resource_disable_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->disable_finish (self, _res_, error);
}


static void usage_resource_real_suspend_data_free (gpointer _data) {
	UsageResourceSuspendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageResourceSuspendData, _data_);
}


static void usage_resource_real_suspend (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UsageResourceSuspendData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (UsageResourceSuspendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_suspend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_suspend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_real_suspend_co (_data_);
}


static void usage_resource_real_suspend_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	UsageResourceSuspendData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_suspend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UsageResourceSuspendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_real_suspend_co (_data_);
}


static gboolean usage_resource_real_suspend_co (UsageResourceSuspendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_status;
	if (_data_->_tmp0_ == FSO_FRAMEWORK_RESOURCE_STATUS_ENABLED) {
		{
			_data_->_tmp1_ = _data_->self->proxy;
			_data_->_state_ = 1;
			free_smartphone_resource_suspend (_data_->_tmp1_, usage_resource_suspend_ready, _data_);
			return FALSE;
			_state_1:
			free_smartphone_resource_suspend_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			_data_->_tmp2_ = usage_instance;
			_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->_tmp2_)->logger;
			_data_->_tmp4_ = _data_->self->priv->_name;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_strconcat ("Suspended resource ", _data_->_tmp5_, " successfully", NULL);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = fso_framework_logger_debug (_data_->_tmp3_, _data_->_tmp7_);
			g_assert (_data_->_tmp8_);
			_g_free0 (_data_->_tmp7_);
			usage_resource_set_status (_data_->self, FSO_FRAMEWORK_RESOURCE_STATUS_SUSPENDED);
			usage_resource_updateStatus (_data_->self);
		}
		goto __finally5;
		__catch5_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp9_ = usage_instance;
			_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->_tmp9_)->logger;
			_data_->_tmp11_ = _data_->self->priv->_name;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = string_to_string (_data_->_tmp14_);
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strconcat ("Resource ", _data_->_tmp12_, " can't be suspended: ", _data_->_tmp15_, ". Trying to disable instead", NULL);
			_data_->_tmp17_ = _data_->_tmp16_;
			fso_framework_logger_error (_data_->_tmp10_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp17_);
			_data_->_tmp18_ = _data_->self->proxy;
			_data_->_state_ = 2;
			free_smartphone_resource_disable (_data_->_tmp18_, usage_resource_suspend_ready, _data_);
			return FALSE;
			_state_2:
			free_smartphone_resource_disable_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_error_free0 (_data_->e);
				goto __finally5;
			}
			_data_->_tmp19_ = _data_->e;
			_data_->_tmp20_ = _g_error_copy0 (_data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e);
			goto __finally5;
		}
		__finally5:
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp21_ = usage_instance;
		_data_->_tmp22_ = ((FsoFrameworkAbstractObject*) _data_->_tmp21_)->logger;
		_data_->_tmp23_ = _data_->self->priv->_name;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = string_to_string (_data_->_tmp23_);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_strconcat ("Resource ", _data_->_tmp24_, " not enabled: not suspending", NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = FALSE;
		_data_->_tmp27_ = fso_framework_logger_debug (_data_->_tmp22_, _data_->_tmp26_);
		g_assert (_data_->_tmp27_);
		_g_free0 (_data_->_tmp26_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_suspend (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->suspend (self, _callback_, _user_data_);
}


void usage_resource_suspend_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->suspend_finish (self, _res_, error);
}


static void usage_resource_real_resume_data_free (gpointer _data) {
	UsageResourceResumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageResourceResumeData, _data_);
}


static void usage_resource_real_resume (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UsageResourceResumeData* _data_;
	UsageResource* _tmp0_;
	_data_ = g_slice_new0 (UsageResourceResumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, usage_resource_real_resume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, usage_resource_real_resume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_resource_real_resume_co (_data_);
}


static void usage_resource_real_resume_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	UsageResourceResumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void usage_resource_resume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UsageResourceResumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_resource_real_resume_co (_data_);
}


static gboolean usage_resource_real_resume_co (UsageResourceResumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_status;
	if (_data_->_tmp0_ == FSO_FRAMEWORK_RESOURCE_STATUS_SUSPENDED) {
		{
			_data_->_tmp1_ = _data_->self->proxy;
			_data_->_state_ = 1;
			free_smartphone_resource_resume (_data_->_tmp1_, usage_resource_resume_ready, _data_);
			return FALSE;
			_state_1:
			free_smartphone_resource_resume_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
			_data_->_tmp2_ = usage_instance;
			_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->_tmp2_)->logger;
			_data_->_tmp4_ = _data_->self->priv->_name;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_strconcat ("Resumed resource ", _data_->_tmp5_, " successfully", NULL);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = fso_framework_logger_debug (_data_->_tmp3_, _data_->_tmp7_);
			g_assert (_data_->_tmp8_);
			_g_free0 (_data_->_tmp7_);
			usage_resource_set_status (_data_->self, FSO_FRAMEWORK_RESOURCE_STATUS_ENABLED);
			usage_resource_updateStatus (_data_->self);
		}
		goto __finally6;
		__catch6_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp9_ = usage_instance;
			_data_->_tmp10_ = ((FsoFrameworkAbstractObject*) _data_->_tmp9_)->logger;
			_data_->_tmp11_ = _data_->self->priv->_name;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = string_to_string (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->e;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = string_to_string (_data_->_tmp14_);
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strconcat ("Resource ", _data_->_tmp12_, " can't be resumed: ", _data_->_tmp15_, ". Trying to disable instead", NULL);
			_data_->_tmp17_ = _data_->_tmp16_;
			fso_framework_logger_error (_data_->_tmp10_, _data_->_tmp17_);
			_g_free0 (_data_->_tmp17_);
			_data_->_tmp18_ = _data_->self->proxy;
			_data_->_state_ = 2;
			free_smartphone_resource_disable (_data_->_tmp18_, usage_resource_resume_ready, _data_);
			return FALSE;
			_state_2:
			free_smartphone_resource_disable_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_error_free0 (_data_->e);
				goto __finally6;
			}
			_data_->_tmp19_ = _data_->e;
			_data_->_tmp20_ = _g_error_copy0 (_data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e);
			goto __finally6;
		}
		__finally6:
		if (_data_->_inner_error_ != NULL) {
			if (((_data_->_inner_error_->domain == FREE_SMARTPHONE_RESOURCE_ERROR) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp21_ = usage_instance;
		_data_->_tmp22_ = ((FsoFrameworkAbstractObject*) _data_->_tmp21_)->logger;
		_data_->_tmp23_ = _data_->self->priv->_name;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = string_to_string (_data_->_tmp23_);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_strconcat ("Resource ", _data_->_tmp24_, " not suspended: not resuming", NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = FALSE;
		_data_->_tmp27_ = fso_framework_logger_debug (_data_->_tmp22_, _data_->_tmp26_);
		g_assert (_data_->_tmp27_);
		_g_free0 (_data_->_tmp26_);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void usage_resource_resume (UsageResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	USAGE_RESOURCE_GET_CLASS (self)->resume (self, _callback_, _user_data_);
}


void usage_resource_resume_finish (UsageResource* self, GAsyncResult* _res_, GError** error) {
	USAGE_RESOURCE_GET_CLASS (self)->resume_finish (self, _res_, error);
}


const gchar* usage_resource_get_name (UsageResource* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void usage_resource_set_name (UsageResource* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const char* usage_resource_get_busname (UsageResource* self) {
	const char* result;
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_busname;
	result = _tmp0_;
	return result;
}


void usage_resource_set_busname (UsageResource* self, const char* value) {
	const char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_busname);
	self->priv->_busname = _tmp1_;
	g_object_notify ((GObject *) self, "busname");
}


const char* usage_resource_get_objectpath (UsageResource* self) {
	const char* result;
	const char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_objectpath;
	result = _tmp0_;
	return result;
}


void usage_resource_set_objectpath (UsageResource* self, const char* value) {
	const char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_objectpath);
	self->priv->_objectpath = _tmp1_;
	g_object_notify ((GObject *) self, "objectpath");
}


FsoFrameworkResourceStatus usage_resource_get_status (UsageResource* self) {
	FsoFrameworkResourceStatus result;
	FsoFrameworkResourceStatus _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}


void usage_resource_set_status (UsageResource* self, FsoFrameworkResourceStatus value) {
	FsoFrameworkResourceStatus _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_status = _tmp0_;
	g_object_notify ((GObject *) self, "status");
}


FreeSmartphoneUsageResourcePolicy usage_resource_get_policy (UsageResource* self) {
	FreeSmartphoneUsageResourcePolicy result;
	FreeSmartphoneUsageResourcePolicy _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_policy;
	result = _tmp0_;
	return result;
}


void usage_resource_set_policy (UsageResource* self, FreeSmartphoneUsageResourcePolicy value) {
	FreeSmartphoneUsageResourcePolicy _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_policy = _tmp0_;
	g_object_notify ((GObject *) self, "policy");
}


GeeArrayList* usage_resource_get_users (UsageResource* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_users;
	result = _tmp0_;
	return result;
}


void usage_resource_set_users (UsageResource* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_users);
	self->priv->_users = _tmp1_;
	g_object_notify ((GObject *) self, "users");
}


GeeArrayList* usage_resource_get_processDependencies (UsageResource* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_processDependencies;
	result = _tmp0_;
	return result;
}


void usage_resource_set_processDependencies (UsageResource* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_processDependencies);
	self->priv->_processDependencies = _tmp1_;
	g_object_notify ((GObject *) self, "processDependencies");
}


GeeArrayList* usage_resource_get_busDependencies (UsageResource* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_busDependencies;
	result = _tmp0_;
	return result;
}


void usage_resource_set_busDependencies (UsageResource* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_busDependencies);
	self->priv->_busDependencies = _tmp1_;
	g_object_notify ((GObject *) self, "busDependencies");
}


static void usage_resource_class_init (UsageResourceClass * klass) {
	usage_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UsageResourcePrivate));
	USAGE_RESOURCE_CLASS (klass)->setPolicy = usage_resource_real_setPolicy;
	USAGE_RESOURCE_CLASS (klass)->setPolicy_finish = usage_resource_real_setPolicy_finish;
	USAGE_RESOURCE_CLASS (klass)->enableShadowResource = usage_resource_real_enableShadowResource;
	USAGE_RESOURCE_CLASS (klass)->enableShadowResource_finish = usage_resource_real_enableShadowResource_finish;
	USAGE_RESOURCE_CLASS (klass)->enable = usage_resource_real_enable;
	USAGE_RESOURCE_CLASS (klass)->enable_finish = usage_resource_real_enable_finish;
	USAGE_RESOURCE_CLASS (klass)->disable = usage_resource_real_disable;
	USAGE_RESOURCE_CLASS (klass)->disable_finish = usage_resource_real_disable_finish;
	USAGE_RESOURCE_CLASS (klass)->suspend = usage_resource_real_suspend;
	USAGE_RESOURCE_CLASS (klass)->suspend_finish = usage_resource_real_suspend_finish;
	USAGE_RESOURCE_CLASS (klass)->resume = usage_resource_real_resume;
	USAGE_RESOURCE_CLASS (klass)->resume_finish = usage_resource_real_resume_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_BUSNAME, g_param_spec_string ("busname", "busname", "busname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_OBJECTPATH, g_param_spec_string ("objectpath", "objectpath", "objectpath", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_STATUS, g_param_spec_enum ("status", "status", "status", FSO_FRAMEWORK_TYPE_RESOURCE_STATUS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_POLICY, g_param_spec_enum ("policy", "policy", "policy", FREE_SMARTPHONE_TYPE_USAGE_RESOURCE_POLICY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_USERS, g_param_spec_object ("users", "users", "users", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_PROCESS_DEPENDENCIES, g_param_spec_object ("processDependencies", "processDependencies", "processDependencies", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_RESOURCE_BUS_DEPENDENCIES, g_param_spec_object ("busDependencies", "busDependencies", "busDependencies", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void usage_resource_usage_iresource_interface_init (UsageIResourceIface * iface) {
	usage_resource_usage_iresource_parent_iface = g_type_interface_peek_parent (iface);
	iface->setPolicy = (void (*)(UsageIResource*, FreeSmartphoneUsageResourcePolicy, GError**)) usage_resource_setPolicy;
	iface->setPolicy_finish = usage_resource_setPolicy_finish;
	iface->enable = (void (*)(UsageIResource*, GError**)) usage_resource_enable;
	iface->enable_finish = usage_resource_enable_finish;
	iface->disable = (void (*)(UsageIResource*, GError**)) usage_resource_disable;
	iface->disable_finish = usage_resource_disable_finish;
	iface->suspend = (void (*)(UsageIResource*, GError**)) usage_resource_suspend;
	iface->suspend_finish = usage_resource_suspend_finish;
	iface->resume = (void (*)(UsageIResource*, GError**)) usage_resource_resume;
	iface->resume_finish = usage_resource_resume_finish;
}


static void usage_resource_instance_init (UsageResource * self) {
	self->priv = USAGE_RESOURCE_GET_PRIVATE (self);
}


static void usage_resource_finalize (GObject* obj) {
	UsageResource * self;
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const char* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const char* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	self = USAGE_RESOURCE (obj);
	_tmp0_ = fso_framework_theLogger;
	_tmp1_ = self->priv->_name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = self->priv->_busname;
	_tmp4_ = string_to_string ((const gchar*) _tmp3_);
	_tmp5_ = self->priv->_objectpath;
	_tmp6_ = string_to_string ((const gchar*) _tmp5_);
	_tmp7_ = g_strconcat ("Resource ", _tmp2_, " served by ", _tmp4_, " (", _tmp6_, ") destroyed", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = fso_framework_logger_debug (_tmp0_, _tmp8_);
	g_assert (_tmp9_);
	_g_free0 (_tmp8_);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_busname);
	_g_free0 (self->priv->_objectpath);
	_g_object_unref0 (self->priv->_users);
	_g_object_unref0 (self->priv->_processDependencies);
	_g_object_unref0 (self->priv->_busDependencies);
	_g_object_unref0 (self->proxy);
	_g_object_unref0 (self->q);
	G_OBJECT_CLASS (usage_resource_parent_class)->finalize (obj);
}


/**
 * Helper class encapsulating a registered resource
 **/
GType usage_resource_get_type (void) {
	return usage_resource_type_id;
}


GType usage_resource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (UsageResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageResource), 0, (GInstanceInitFunc) usage_resource_instance_init, NULL };
	static const GInterfaceInfo usage_iresource_info = { (GInterfaceInitFunc) usage_resource_usage_iresource_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	usage_resource_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "UsageResource", &g_define_type_info, 0);
	g_type_module_add_interface (module, usage_resource_type_id, USAGE_TYPE_IRESOURCE, &usage_iresource_info);
	return usage_resource_type_id;
}


static void _vala_usage_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UsageResource * self;
	self = USAGE_RESOURCE (object);
	switch (property_id) {
		case USAGE_RESOURCE_NAME:
		g_value_set_string (value, usage_resource_get_name (self));
		break;
		case USAGE_RESOURCE_BUSNAME:
		g_value_set_string (value, usage_resource_get_busname (self));
		break;
		case USAGE_RESOURCE_OBJECTPATH:
		g_value_set_string (value, usage_resource_get_objectpath (self));
		break;
		case USAGE_RESOURCE_STATUS:
		g_value_set_enum (value, usage_resource_get_status (self));
		break;
		case USAGE_RESOURCE_POLICY:
		g_value_set_enum (value, usage_resource_get_policy (self));
		break;
		case USAGE_RESOURCE_USERS:
		g_value_set_object (value, usage_resource_get_users (self));
		break;
		case USAGE_RESOURCE_PROCESS_DEPENDENCIES:
		g_value_set_object (value, usage_resource_get_processDependencies (self));
		break;
		case USAGE_RESOURCE_BUS_DEPENDENCIES:
		g_value_set_object (value, usage_resource_get_busDependencies (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_usage_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UsageResource * self;
	self = USAGE_RESOURCE (object);
	switch (property_id) {
		case USAGE_RESOURCE_NAME:
		usage_resource_set_name (self, g_value_get_string (value));
		break;
		case USAGE_RESOURCE_BUSNAME:
		usage_resource_set_busname (self, g_value_get_string (value));
		break;
		case USAGE_RESOURCE_OBJECTPATH:
		usage_resource_set_objectpath (self, g_value_get_string (value));
		break;
		case USAGE_RESOURCE_STATUS:
		usage_resource_set_status (self, g_value_get_enum (value));
		break;
		case USAGE_RESOURCE_POLICY:
		usage_resource_set_policy (self, g_value_get_enum (value));
		break;
		case USAGE_RESOURCE_USERS:
		usage_resource_set_users (self, g_value_get_object (value));
		break;
		case USAGE_RESOURCE_PROCESS_DEPENDENCIES:
		usage_resource_set_processDependencies (self, g_value_get_object (value));
		break;
		case USAGE_RESOURCE_BUS_DEPENDENCIES:
		usage_resource_set_busDependencies (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



