package freenet.node.states.announcing;

import freenet.node.states.request.*;
import freenet.*;
import freenet.node.*;
import freenet.support.Fields;
import freenet.support.Logger;

public class NewInitialRequest extends State {

    static void schedule(Node n, Key k, AnnouncementRequestToken ft) {
        long id = n.randSource.nextLong();
        n.logger.log(NewInitialRequest.class,
            "Scheduling post-announcement request on chain "
            +Fields.longToHex(id)+", for key "+k,
            Logger.NORMAL);
        n.schedule(new MakeInitialRequest(id, Node.initialRequestHTL, k, ft));
    }

    private static class MakeInitialRequest extends EventMessageObject {
        private int htl;
        private Key key;
        private AnnouncementRequestToken ft;
        private MakeInitialRequest(long id, int htl, Key key,
                                   AnnouncementRequestToken ft) {
            super(id, true);
            this.htl = htl;
            this.key = key;
            this.ft  = ft;
        }
        public State getInitialState() {
            return new NewInitialRequest(this.id, htl, key, ft);
        }
    }

    
    private int htl;    
    private Key key;
    private AnnouncementRequestToken ft;

    private NewInitialRequest(long id, int htl, Key key,
                              AnnouncementRequestToken ft) {
        super(id);
        this.htl = htl;
        this.key = key;
        this.ft  = ft;
    }

    public String getName() {
        return "New Initial Request post announcement";
    }

    public State received(Node n, MessageObject mo) throws StateException { 
        if (!(mo instanceof MakeInitialRequest))
            throw new BadStateException("Expecting MakeInitialRequest");
        RequestInitiator ri = new RequestInitiator(id);
        return (new DataPending(id, htl, key, null, ft, ri)).received(n, ri);
    }

    public void lost(Node n) {
        ft.queryRejected(n, htl, "Node lost state", null, 0, 0, 0);
    }
}


