package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import freenet.client.*;
import java.io.InputStream;

/** This is for the FCP ClientPut message.
  */
public class ClientPut extends ClientRequest {

    public static final String messageName = "ClientPut";

    public ClientPut(ConnectionHandler source, RawMessage raw) {
        super(source, raw, true);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing ClientPut message.")
            : (State) new NewClientPut(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}
