package freenet.fs;

/**
 * A LockGrantor is a central accounting device that should
 * keep track of active locks so that it can arrange the
 * correct blocking behaviors through the LockSlide objects.
 * @author tavin
 */
public interface LockGrantor {

    /**
     * @return  the object that is synchronized on whenever a lock
     *          is granted;  the application code can explicitly
     *          synchronize on this in order to obtain a group of
     *          locks as a single operation
     */
    Object semaphore();

    /**
     * This is called in only one place: the Lock constructor.
     * 
     * Adds the ticket to the list of active locks, and determines
     * the locks that the lock being granted must block on.
     * 
     * One or more LockSignals may be registered with the ticket
     * during the execution of this method.  The LockGrantor
     * itself should register one to discover when active locks
     * are unlocked.
     *
     * The Storage reference in the ticket must also be set.
     *
     * @param ticket    the ticket of the lock being granted
     * @param protMask  the protection mask of the lock being granted
     *
     * @return  a LockSlide object made by calculating
     *          what locks the new lock must block on
     */
    LockSlide grant(LockTicket ticket, int protMask);
}



