package freenet.client.events;
import freenet.client.*;

/**
 * The RestartedEvent is produced when either a request was restarted
 * by an upstream node.  The library will then continue to wait for
 * the request to complete.
 *
 * @author oskar
 **/
public class RestartedEvent implements ClientEvent {
    public static final int code = 0x04;
    private int secs;
    
    public RestartedEvent(long millis) {
        this.secs = (int) (millis / 1000);
    }
    
    public String getDescription() {
        return "The query was restarted somewhere on Freenet after a node failed to reply, waiting another " + secs + " seconds before I give up";
    }
    
    /**
     * Returns the number of seconds the library will continue to wait
     */
    public int getTime() {
        return secs;
    }

    public int getCode() {
        return code;
    }
}
