//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryCondition.hpp,v 1.2 2004/04/16 16:25:41 delpinux Exp $

#ifndef BOUNDARYCONDITION_HPP
#define BOUNDARYCONDITION_HPP

#include <Boundary.hpp>
#include <PDECondition.hpp>

/*!
  \class BoundaryCondition

  This class is used to describe sets of boundary conditions applied to a
  scalar unknown.

  \author Stphane Del Pino
*/

class BoundaryCondition
{
private:
  //! a PDE like condition.
  ReferenceCounting<PDECondition> __pdeCondition;

  //! The associated boundary.
  ReferenceCounting<Boundary> __boundary;

public:

  //! read only access to the boundary.
  const Boundary& boundary() const
  {
    return *__boundary;
  }

  //! Access to the boundary Reference.
  ReferenceCounting<Boundary> boundaryReference() const
  {
    return __boundary;
  }

  //! read only access to the condition.
  const PDECondition& condition() const
  {
    return *__pdeCondition;
  }

  //! Access to the boundary Reference.
  ReferenceCounting<PDECondition> pdeConditionReference() const
  {
    return __pdeCondition;
  }

  //! Writes the boundary condition.
  friend std::ostream& operator << (std::ostream& os,
				    const BoundaryCondition&  BC)
  {
    os << "Boundary Condition\n";
    os << *BC.__pdeCondition;
    os << *BC.__boundary;
    return os;
  }

  //! Constucts a BC using a Boundary and a Condition.
  BoundaryCondition(ReferenceCounting<PDECondition> pdeCondition,
		    ReferenceCounting<Boundary> aBoundary)
    : __pdeCondition(pdeCondition),
      __boundary(aBoundary)
  {
    ;
  }
};

#endif // BOUNDARYCONDITION_HPP

