//
// C++ Interface: alsaseqmidiinput
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ALSASEQMIDIINPUT_H
#define ALSASEQMIDIINPUT_H

#include <qobject.h>
#include "defs.h"
#include "qstringlist.h"
#include "soundplayer.h"
#include "beatlinedata.h"
#include "midiinputevent.h"
#include "midiinput.h"
#include "alsa/asoundlib.h"

/**
@author Predrag Viceic
*/
class AlsaSeqMidiInput : public MidiInput
{
Q_OBJECT
public:
    AlsaSeqMidiInput(QObject *parent = 0, const char *name = 0);
    virtual void process();
    virtual void printMessage(int msg);
    virtual QString getSelectedDeviceString();
    virtual QString getDefaultDeviceString();
    virtual QStringList getDevices();
    virtual void setMidiChannel(int c);
    virtual int openDevice(QString device);

    ~AlsaSeqMidiInput();
    #define NONE "None"
    
protected:
    void initThread();
    snd_seq_t *seq_handle;
    int exportedClientPortid;
    int exportedClientClientid;
    QString exportedClient;
    QString selectedClient;
    int subscribedToClient;
    int subscribedToPort;
    int npfd;
    struct pollfd *pfd;
    bool threadInitDone;

};

#endif
