#include <gnome.h>
#include "fpm.h"
#include "support.h"



static gint
fpm_cmp_title(fpm_data *a, fpm_data *b)
{
  return(g_strcasecmp(a->title, b->title));
}

void
fpm_create_category_list(gint edit_flag)
{
  GList *list;
  fpm_data *data;
  GCompareFunc cmp_func;


  /* Clear cat list */
  list = g_list_first(glb_cat_string_list);
  while(list!=NULL)
  {
    g_assert(list->data!=NULL);
    g_free(list->data);
    list=g_list_next(list);
  }
  g_list_free(glb_cat_string_list);
  glb_cat_string_list = NULL;

  cmp_func = (GCompareFunc) g_strcasecmp;

  /* Step through pass list adding to cat list */
  list = g_list_first(glb_pass_list);
  while(list!=NULL)
  {
    data = list->data;
    if (
    /*
        strcmp(data->category, "") &&
	*/
        g_list_find_custom(glb_cat_string_list, data->category, cmp_func) ==NULL)
    {
      g_assert(data->category !=NULL);
      glb_cat_string_list=g_list_insert_sorted(glb_cat_string_list,
      	g_strdup(data->category), cmp_func);
    }
    
    list=g_list_next(list);
  }



  if(edit_flag)
  {
    /* Add first item entry to beginning of list */
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(""));
  }
  else
  {
    /* Add all category and default category */
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(FPM_DEFAULT_CAT_MSG));
    glb_cat_string_list=g_list_prepend(glb_cat_string_list, g_strdup(FPM_ALL_CAT_MSG));
  }
}

void
fpm_check_view(gchar * category)
{
  g_free(glb_last_category);
  glb_last_category=g_strdup(category);
  fpm_clist_create_view(category);
}

void
fpm_clist_populate_cat_list()
{ 
  GtkOptionMenu* option_menu;
  GtkWidget* menu;
  GList* list;
  GtkWidget* menu_item;
  gint i, index;

  fpm_create_category_list(0);
  g_assert(glb_cat_string_list!=NULL);
  g_assert(glb_last_category!=NULL);

  option_menu=GTK_OPTION_MENU(lookup_widget(glb_win_app, "optionmenu_category"));
  gtk_option_menu_remove_menu(option_menu);
  menu=gtk_menu_new();
  gtk_option_menu_set_menu(option_menu, menu);


  list=g_list_first(glb_cat_string_list);
  i=0;
  index=0;
  while(list!=NULL)
  {
    menu_item=gtk_menu_item_new_with_label(g_strdup(list->data));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect_object(GTK_OBJECT(menu_item), "activate",
	GTK_SIGNAL_FUNC(fpm_check_view), (gpointer) g_strdup(list->data));

    if(!strcmp(glb_last_category, list->data))
    { 
      index=i;
      gtk_menu_item_activate(GTK_MENU_ITEM(menu_item));
    }
    i++;
    list=g_list_next(list);
  }

  gtk_option_menu_set_history(option_menu, index);

}





void
fpm_clist_create_view(gchar *  category)
/* Create visible CList from abstract GList */
{
  gint i, row;
  gchar* blank_row[FPM_NUM_COL];
  fpm_data *data;
  GList *list;

  /* Construct blank row */
  for(i=0;i<FPM_NUM_COL; i++) blank_row[i]=NULL;
 
  /* Freeze the CList */
  gtk_clist_freeze(glb_clist_main);

  /* Clear all rows from the CList */
  gtk_clist_clear(glb_clist_main);

  glb_num_row=0;

  /* Sort the list */
  glb_cmp=(GCompareFunc) fpm_cmp_title;
  glb_pass_list=g_list_sort(glb_pass_list, glb_cmp);

  /* Iterate over the list */
  list=g_list_first(glb_pass_list);
  while (list!=NULL)
  {

    /* Get data for this element */
    data = list->data;

    if(category == NULL ||
       !strcmp(category, FPM_ALL_CAT_MSG) ||
       !strcmp(category, data->category) ||
       (!strcmp(category, FPM_DEFAULT_CAT_MSG) && data->default_list) )
    { 
      /* Insert new blank row and increment counters */
      gtk_clist_append(glb_clist_main, blank_row);
      glb_num_row++;
      row = glb_num_row - 1;

      /* Associate this CList with the data structure */
      gtk_clist_set_row_data(glb_clist_main, row, data);

      /* Update visible clist fields */
      gtk_clist_set_text(glb_clist_main, row, FPM_COL_TITLE, data->title);
      gtk_clist_set_text(glb_clist_main, row, FPM_COL_URL, data->arg);
      gtk_clist_set_text(glb_clist_main, row, FPM_COL_USER, data->user);
    }

    list=g_list_next(list);
  }
  
  /* Setting this to NULL tells app no row is selected.*/
/*
  glb_edit_data=NULL;
  glb_cur_row=0;
*/

  gtk_clist_thaw(glb_clist_main);
} 

