{
    $Id: filutilh.inc,v 1.5 2004/05/01 11:56:25 marco Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2000 by the Free Pascal development team

    File utility calls

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

Type
  TSearchRec = Record
    Time : Longint;
    Size : Int64;
    Attr : Longint;
    Name : TFileName;
    ExcludeAttr : Longint;
{$ifdef unix}    
    FindHandle : Pointer;
{$else unix}
    FindHandle : THandle;
{$endif unix}    
{$ifdef Win32}
    FindData : TWin32FindData;
{$endif}
{$ifdef netware}
    FindData : TNetwareFindData;
{$endif}
  end;

Const
  { File attributes }
  faReadOnly  = $00000001;
  faHidden    = $00000002;
  faSysFile   = $00000004;
  faVolumeId  = $00000008;
  faDirectory = $00000010;
  faArchive   = $00000020;
  faAnyFile   = $0000003f;

  { File open modes }
  fmOpenRead       = $0000;
  fmOpenWrite      = $0001;
  fmOpenReadWrite  = $0002;
  { Share modes}
  fmShareCompat    = $0000;
  fmShareExclusive = $0010;
  fmShareDenyWrite = $0020;
  fmShareDenyRead  = $0030;
  fmShareDenyNone  = $0040;

  { File seek origins }
  fsFromBeginning = 0;
  fsFromCurrent   = 1;
  fsFromEnd       = 2;

Function FileOpen (Const FileName : string; Mode : Integer) : Longint;
Function FileCreate (Const FileName : String) : Longint;
Function FileCreate (Const FileName : String; Mode : Integer) : Longint;
Function FileRead (Handle : Longint; Var Buffer; Count : longint) : Longint;
Function FileWrite (Handle : Longint; const Buffer; Count : Longint) : Longint;
Function FileSeek (Handle,FOffset,Origin : Longint) : Longint;
Function FileSeek (Handle : Longint; FOffset,Origin : Int64) : Int64;
Procedure FileClose (Handle : Longint);
Function FileTruncate (Handle,Size: Longint) : boolean;
Function FileAge (Const FileName : String): Longint;
Function FileExists (Const FileName : String) : Boolean;
Function DirectoryExists (Const Directory : String) : Boolean;
Function FindFirst (Const Path : String; Attr : Longint; Var Rslt : TSearchRec) : Longint;
Function FindNext (Var Rslt : TSearchRec) : Longint;
Procedure FindClose (Var F : TSearchrec);
Function FileGetDate (Handle : Longint) : Longint;
Function FileSetDate (Handle,Age : Longint) : Longint;
Function FileGetAttr (Const FileName : String) : Longint;
Function FileSetAttr (Const Filename : String; Attr: longint) : Longint;
Function DeleteFile (Const FileName : String) : Boolean;
Function RenameFile (Const OldName, NewName : String) : Boolean;
Function FileSearch (Const Name, DirList : String) : String;
Function FileIsReadOnly(const FileName: String): Boolean; 

Function GetFileHandle(var f : File):Longint;
Function GetFileHandle(var f : Text):Longint;

{
  $Log: filutilh.inc,v $
  Revision 1.5  2004/05/01 11:56:25  marco
   * fileno -> getfilehandle

  Revision 1.4  2004/05/01 11:04:34  marco
   * fileno

  Revision 1.3  2004/04/28 20:48:20  peter
    * ordinal-pointer conversions fixed

  Revision 1.2  2004/02/08 14:50:51  michael
  + Added fileIsReadOnly

  Revision 1.1  2003/10/06 21:01:06  peter
    * moved classes unit to rtl

  Revision 1.10  2003/04/01 15:57:41  peter
    * made THandle platform dependent and unique type

  Revision 1.9  2003/03/29 18:21:41  hajny
    * DirectoryExists declaration changed to that one from fixes branch

  Revision 1.8  2003/03/28 19:06:59  peter
    * directoryexists added

  Revision 1.7  2003/01/03 20:41:04  peter
    * FileCreate(string,mode) overload added

  Revision 1.6  2002/09/07 16:01:22  peter
    * old logs removed and tabs fixed

}
