/***************************************************************************
 *
 *		File		: poplib.h
 *
 *		Title		: POP Checking program
 *
 *		Description	: Connects to port 110 (POP) and uses STAT to check for new
 *						mail.  Prints out debugging code to stderr, and the
 *						result to stdout.  Needs alot of work.  GUI element is
 *						a straight lift from gtk+/examples/buttons/buttons.c.
 *						The networking code is very simple.  This should really
 *						be a corba object called by a corba based gnome-biff.
 *						
 *		Author		: Andrae Muys <andrae@humbug.org.au>
 *					Modified by Marcus Leyman (6 May 2001)			
 *
 *		License		: LGPL (latest @ 26 May 1999).
 *
 *		Date		: 26th May 1999
 *		History		: 29th May 1999 - seperated POP code from Gtk code.
 *
 ***************************************************************************/

#ifndef POPLIB_H
#define POPLIB_H

/** See RFC 1939 for protocol details **/

#define POP_PORT 110

typedef struct {
	int sd;
	char *host;
	int state;
#		define POP_NONE   0
#		define POP_AUTH   1
#		define POP_TRANS  2
#		define POP_UPDATE 3
} popLink;

typedef struct {
	char *err;
	int msgs;
	long bytes;
} popStatInfo;

/** popConnect()
 *		Connect to POP port on host.  Leaves connection in AUTH state.
 *	RETURNS: link-structure on success.  NULL on failure.
 */
popLink *popConnect (char *host);

/** popDisconnect()
 *		Disconnect from POP port.  Host should enter UPDATE state.  `link' is
 *		freed.
 */
void popDisconnect (popLink *link);

/** popStdLogin()
 *		Login using USER/PASS.  Leaves server in TRANSACTION state on success,
 *		AUTH state on failure.
 *	RETURNS: Result string on failure, NULL on success.
 */
char *popStdLogin (popLink *link, char *user, char *pass);

/** popStatistics()
 *		Returns statistics from POP server.
 *	RETURNS: popStatInfo->err==NULL on success == Error string on failure.
 */
popStatInfo *popStatistics (popLink *link);

#endif
