/***************************************************************************
 *
 *		File		: imaplib.h
 *
 *		Title		: IMAPv4 connect/mailcheck library
 *
 *		Description	: Connects to a IMAPv4 server and stats
 *				  for new e-mail.
 *
 *		Author		: Marcus Leyman, 2001
 *
 *		License		: GPL
 *		
 *		Date		: 6 May 2001
 *
 **************************************************************************/
 
#include <sys/socket.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>

#include "imaplib.h"

imapLink *imapConnect (char *host)
{
	imapLink *link = NULL;
	struct sockaddr_in server;
	struct hostent *hent;
	char response[513];
	int len;

	if (!host)
		return NULL;

	hent = gethostbyname (host);
	if (!hent) {
		return NULL;
	}
	memset (&server, 0, sizeof(server));
	server.sin_family = AF_INET;
	memcpy (&(server.sin_addr.s_addr), hent->h_addr,
				sizeof(server.sin_addr.s_addr));

	server.sin_port = htons (143);	

	link = (imapLink *)malloc (sizeof(imapLink));
	link->state = IMAP_NONE;
	link->host = NULL;
	link->sd = socket (PF_INET, SOCK_STREAM, 0);
	if (link->sd < 0) {
		perror ("imapchk");
		return NULL;
	}
	if (connect (link->sd, &server, sizeof(server)) < 0) {
		perror ("imapchk");
		imapDisconnect (link);
		return NULL;
	}

	len = read (link->sd, response, 512);
	response[len] = '\0';

	if (strncmp (response, "* OK", 3)) {
		close (link->sd);
		imapDisconnect (link);
		return NULL;
	} 

	link->state = IMAP_AUTH;
	link->host = strdup(host);

	return link;
}

void imapDisconnect (imapLink *link)
{
	if (link->state != IMAP_NONE) {
		write (link->sd, "a003 LOGOUT\r\n", strlen ("a003 LOGOUT\r\n"));
		close (link->sd);
	}
	free (link->host);
	free (link);
}

char *imapStdLogin (imapLink *link, char *user, char *pass)
{
	char cmdline[100];  
	char response[513];
	int len;

	if (!user || !pass)
		return strdup ("Username/Password unspecified.\n");

	if (link->state != IMAP_AUTH) {
		return strdup ("Login attempt in invalid state.\n");
	}
	
	sprintf (cmdline, "a001 LOGIN %s %s\r\n", user, pass);
	write (link->sd, cmdline, strlen(cmdline));
	len = read (link->sd, response, 512);
	response[len] = '\0';

	if (strncmp (response, "a001 OK", 3)) {
		return strdup(response);
	} 

	link->state = IMAP_TRANS;
	return NULL;
}

imapStatInfo *imapStatistics (imapLink *link, char *folder)
{
	imapStatInfo *info;
	char cmdline[100];
	char response[513];
	char *responsetmp;
	int len;
	int tmp_nr;
	char tmpch;

	info = (imapStatInfo *)malloc (sizeof(imapStatInfo));
	if (link->state != IMAP_TRANS) {
		info->err = strdup ("PASS attempt in invalid state.\n");
		return info;
	}
	sprintf (cmdline, "a002 STATUS %s (UNSEEN MESSAGES)\r\n", folder);
	write (link->sd, cmdline, strlen(cmdline));
	len = read (link->sd, response, 512);
	response[len] = '\0';

        responsetmp = strstr(response, "UNSEEN");

        sscanf(responsetmp, "UNSEEN %d", &(info->msgs_new));


	return info;
}
