#!/bin/sh
# Irssi multichannel stats example script for FISG
# ------------------------------------------------
# This simple shell-script makes creating stats for
# multiple channels somewhat easier. Usage:
#
# 1) Set channels and other settings below
#
# 2) Create configfiles for all channels and name them
#    to channel names without "#", like: #foo -> foo.cfg
#
# 3) Run this script:
#
# $ chmod u+x irssi-multichan.sh
# $ ./irssi-multichan.sh
#
# OR just: sh irssi-multichan.sh
#
# 4) The result is number of HTML-files under specified directory

# Path to FISG binary executable (if not in $PATH)
MFISG="./fisg"

# Define the channels
MCHANNELS="#foo #bar #chat.org #elitez"

# Logfile path. Set this to directory, where your logfiles are.
MLOGPATH="~/irclogs/IRCnet"

# Directory path where stats HTMLs will be created
MHTMLPATH="testdir"

# HTML filename prefix:
MHTMLPREFIX="stats-"

# HTML filename suffix:
MHTMLSUFFIX=".html"


# Generic configuration file. This will be read before
# channel specific configuration, set globals here.
MCONFIG="defaults.cfg"


############################################################
### End of user configurable parts
############################################################
for ICHANNEL in $MCHANNELS; do
	$INAME=`echo $ICHANNEL|sed "s/^[#!&]//"`.cfg
	if test -f $INAME; then
	COPT="-c $INAME"
	else
	COPT=""
	fi
	$MFISG -c $MCONFIG $COPT $MLOGPATH/ -o "$MHTMLPATH/$MHTMLPREFIX$INAME$MHTMLSUFFIX"
done

