/*
 * FISG - Input Formats (NOTICE! THIS IS NOT A REAL HEADER FILE!)
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _IN_FORMATS_H
#define _IN_FORMATS_H

/*
 * Defination of the in-format structure
 */
typedef struct {
	char	*ifName,	/* Name of this logfile-format */
		*ifDescription,	/* Short description */

		*fmtPublic,	/* Format-string for public messages */
		*fmtNotice,
		*fmtAction,
		*fmtMode,
		*fmtJoin,
		*fmtPart,
		*fmtQuit,
		*fmtKick,
		*fmtNickChange,
		
		*fmtDayChange;
} t_logformat;


/*
 * List of pre-defined input formats
 */
t_logformat	inputFormats[] = {

	{ "irssi", "Handles the DEFAULT Irssi-style logs",
		"%H:%M <%@%n> %t",
		"%H:%M -%n:%c- %t",
		"%H:%M  * %n %t",
		"%H:%M -!- mode/%c [%m] by %n",
		"%H:%M -!- %n [%*] has joined %c",
		"%H:%M -!- %n [%*] has left %c",
		"%H:%M -!- %n [%*] has quit ",
		"%H:%M -!- %n was kicked from %c by %N",
		"%H:%M -!- %n is now known as %N",
		"--- Day changed"
	},
	
	{ "irssi-th", "Handles the 'th-style' Irssi-style logs",
		"%H:%M:%S<%@%n> %t",
		"%H:%M:%S-%n:%c- %t",
		"%H:%M:%S * %n %t",
		"%H:%M:%S-!- mode/%c [%m] by %n",
		"%H:%M:%S-!- %n [%*] has joined %c",
		"%H:%M:%S-!- %n [%*] has left %c",
		"%H:%M:%S-!- %n [%*] has quit ",
		"%H:%M:%S-!- %n was kicked from %c by %N",
		"%H:%M:%S-!- %n is now known as %N",
		"--- Day changed"
	},
	
	{ "eggdrop", "Eggdrop log-format",
		"[%H:%M] <%n> %t",
		"-fewr",
		"[%H:%M] Action: %n %t",
		"[%H:%M] %c: mode change '%m' by %n!",
		"[%H:%M] %n (%*) joined %c",
		"[%H:%M] %n (%*) left %c (",
		"[%H:%M] %n (%*) left irc:",
		"[%H:%M] %n kicked from %c by %N:",
		"[%H:%M] Nick change: %n -> %N",
		"[%H:%M] ---"
	},

	{ "mirc", "mIRC basic log-format",
		"[%H:%M:%S] <%n> %t",
		"[%H:%M:%S] -%n- %t",
		"[%H:%M:%S] Action: %n",
		"[%H:%M:%S] * %n sets mode: %m",
		"[%H:%M:%S] * Joins: %n",
		"[%H:%M:%S] %n (%*) ",
		"[%H:%M:%S] %n (%*) left irc:  ",
		"[%H:%M:%S] %n kicked from %c by %N:",
		"[%H:%M:%S] Nick change: %n -> %N",
		"-fdsfsd"
	},

	{ "bitchx", "Does not work :)",
		"\x1b%*m<\x1b%*m%n\x1b%*m:\x1b%*m%c\x1b%*m>\x1b%*m %t\x1b",
		"-%n:%c- %t",
		"%H:%M  * %n %t",
		"%H:%M -!- mode/%c [%m] by %n",
		"%H:%M -!- %n [%*] has joined %c",
		"%H:%M -!- %n [%*] has left %c",
		"%H:%M -!- %n [%*] has quit ",
		"%H:%M -!- %n was kicked from %c by %N",
		"%H:%M -!- %n is now known as %N",
		"--- Day changed"
	},
	
	{ "quuxremix", "quuxremix logs",
		"%d.%j.%Y %H%M  %@%n: %t",
		"%d.%j.%Y %H%M  notice/%c: %t",
		"%d.%j.%Y %H%M  * %n %t",
		"%d.%j.%Y %H%M  %*| %c: %m by %n",
		"%d.%j.%Y %H%M  %n+ (%*) (%*) joins %c",
		"%d.%j.%Y %H%M  %n- (%*) parts %c",
		"%d.%j.%Y %H%M  %n- (%*) quits",
		"%d.%j.%Y %H%M  %n was kicked from %c by %N",
		"%d.%j.%Y %H%M  %n is now known as %N",
		"--- Day changed",
	},

};


const int	nInputFormats = (sizeof(inputFormats) / sizeof(t_logformat));

#endif /* _IN_FORMATS_H */
