#ifndef _CDLGIPTABLESRULES_HH
#define _CDLGIPTABLESRULES_HH

#include <gtkmm.h>
#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <config.h>
#include "fireflierIO.h"
#include "dispatcher.h"
#include "CSync.h"

#ifdef WITHGCONF
#include "CGConf.h"
#endif

using Glib::ustring;



class CDlgIPTablesRules: public Gtk::Window, public CSync
{
private:
	class CIPTablesRulesColumnRecord: public Gtk::TreeModel::ColumnRecord
	{
	public:
		Gtk::TreeModelColumn <ustring> m_colIPTablesRule;
		
		CIPTablesRulesColumnRecord()
		{
			add(m_colIPTablesRule);
		}
	};
	
	static const CIPTablesRulesColumnRecord m_colRecord;
	Glib::RefPtr <Gtk::TreeStore> m_pTreeStoreIPTablesRules;
	Glib::RefPtr <Gtk::TreeSelection> m_pTreeSel;
	Dispatcher1 <int> m_signalAuthentication;
	Dispatcher2 <CffIO::pCffIOError, bool> m_signalNetworkThreadError;
	Dispatcher2 <const char*, int> m_signalIPTablesRulesAvail;
#ifdef WITHGCONF
	CGConfUI m_gconfUI;
#endif

protected:
	Gtk::Button m_butDel;
	Gtk::TreeView m_tvIPTablesRules;


public:
	CDlgIPTablesRules();
	virtual ~CDlgIPTablesRules();
	

private:

protected:
#ifdef WITHGCONF
	void on_value_changed(const ustring& strKey, const Gnome::Conf::Value& value);
	void on_butCancel_clicked();
	bool on_delete(GdkEventAny*);
	void save_pos_and_size();
#endif
	void initGUI();
	void on_butDel_clicked();
	void on_IPTablesRules_avail(const char* szMsg, int nLen);
	bool on_Selection_changing(	const Glib::RefPtr <Gtk::TreeModel>& ptm, 
								const Gtk::TreePath& path, 
								bool bSelLost);
	
	void on_selection_changed();
	
	// callback for Gtk::TreeSelection::selected_foreach
	static void deleteRule(const Gtk::TreePath& path, int* pnCount, int* pnPath);
	// callback just to find out whether any node is selected
	static void isAnySelected(const Gtk::TreePath& path, bool* bWasHere);

	// callbacks for the network thread
	void on_Authentication(int nAuthenticated);
	void on_networkthread_error(CffIO::pCffIOError pErr, bool bDisconnected);
};

#endif
