#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2006 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the remark string functionality
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

no_result()
{
	set +x
	echo 'NO RESULT test of the remark string functionality' 1>&2
	cd $here
	rm -rf $work
	exit 2
}
fail()
{
	set +x
	echo 'FAILED test of the remark string functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 2; fi
mkdir $work
if test $? -ne 0 ; then exit 2; fi
cd $work
if test $? -ne 0 ; then no_result; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the remark string options
#
echo "one" > the-file
if test $? -ne 0 ; then no_result; fi
mkdir FHIST
if test $? -ne 0 ; then no_result; fi

$bin/fhist -create the-file -rs 'remark one' > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

echo "two" >> the-file
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -rs 'remark two' > LOG 2>&1
if test $? -ne 0 ; then cat LOG; no_result; fi

cat > the-file << 'fubar'
This
is version
three
of the file.
fubar
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -rs 'this is the third string' > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cat > the-file << 'fubar'
This
is
the
fourth
version
of
the
file.
fubar
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -rs 'this is
the number 4 remark' > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

#
# Now make sure we can list it.
#
$bin/fhist the-file -list > test.out.raw 2>&1
if test $? -ne 0 ; then cat test.out.raw; fail; fi

sed 's/\(Edit [1-9]:\) .*/\1/' < test.out.raw > test.out
if test $? -ne 0 ; then no_result; fi

cat > test.ok << 'fubar'
Module "the-file":
Edit 4:
this is
the number 4 remark

Edit 3:
this is the third string

Edit 2:
remark two

Edit 1:
remark one
fubar
if test $? -ne 0 ; then no_result; fi

diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
