// This code conforms with the UFC specification version 1.4.1
// and was automatically generated by FFC version 0.9.3.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __SPATIALCOORDINATES_H
#define __SPATIALCOORDINATES_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class spatialcoordinates_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  spatialcoordinates_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, -0.17320508, -0.10000000, 0.12171612, 0.09428090, 0.05443311};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, 0.17320508, -0.10000000, 0.12171612, -0.09428090, 0.05443311};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, 0.00000000, 0.20000000, 0.00000000, 0.00000000, 0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.23094011, 0.13333333, 0.00000000, 0.18856181, -0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, -0.23094011, 0.13333333, 0.00000000, -0.18856181, -0.16329932};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.00000000, -0.26666667, -0.24343225, 0.00000000, 0.05443311};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, -0.17320508, -0.10000000, 0.12171612, 0.09428090, 0.05443311};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, 0.17320508, -0.10000000, 0.12171612, -0.09428090, 0.05443311};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.00000000, 0.00000000, 0.20000000, 0.00000000, 0.00000000, 0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.23094011, 0.13333333, 0.00000000, 0.18856181, -0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, -0.23094011, 0.13333333, 0.00000000, -0.18856181, -0.16329932};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[6] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      double tmp1 = (1.00000000 - Y)/2.00000000;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 2; r++)
      {
        rr = (r + 1)*((r + 1) + 1)/2;
        ss = r*(r + 1)/2;
        tt = (r - 1)*((r - 1) + 1)/2;
        tmp5 = (1.00000000 + 2.00000000*r)/(1.00000000 + r);
        basisvalues[rr] = (basisvalues[ss]*tmp0*tmp5 - basisvalues[tt]*tmp2*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 1; s < 2 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)/2 + s + 1;
          ss = (r + s)*(r + s + 1)/2 + s;
          tt = (r + s - 1)*(r + s - 1 + 1)/2 + s - 1;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp6 + Y*tmp5) - basisvalues[tt]*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 3; r++)
      {
        for (unsigned int s = 0; s < 3 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[6] = \
      {0.47140452, 0.00000000, -0.26666667, -0.24343225, 0.00000000, 0.05443311};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 9.48683298, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.00000000, 0.00000000, 7.07106781, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[6][6] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.58198890, 4.74341649, -0.91287093, 0.00000000, 0.00000000, 0.00000000},
      {2.00000000, 6.12372436, 3.53553391, 0.00000000, 0.00000000, 0.00000000},
      {-2.30940108, 0.00000000, 8.16496581, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
      y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    y[1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class spatialcoordinates_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  spatialcoordinates_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~spatialcoordinates_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + m.num_entities[1];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 6;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 6;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += m.num_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.50000000*x[1][0] + 0.50000000*x[2][0];
    coordinates[3][1] = 0.50000000*x[1][1] + 0.50000000*x[2][1];
    coordinates[4][0] = 0.50000000*x[0][0] + 0.50000000*x[2][0];
    coordinates[4][1] = 0.50000000*x[0][1] + 0.50000000*x[2][1];
    coordinates[5][0] = 0.50000000*x[0][0] + 0.50000000*x[1][0];
    coordinates[5][1] = 0.50000000*x[0][1] + 0.50000000*x[1][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class spatialcoordinates_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  spatialcoordinates_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    8
    // Number of operations (multiply-add pairs) for tensor contraction: 49
    // Total number of operations (multiply-add pairs):                  68
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = det*(K_00*K_00 + K_01*K_01);
    const double G0_0_1 = det*(K_00*K_10 + K_01*K_11);
    const double G0_1_0 = det*(K_10*K_00 + K_11*K_01);
    const double G0_1_1 = det*(K_10*K_10 + K_11*K_11);
    
    // Compute element tensor
    A[0] = 0.50000000*G0_0_0 + 0.50000000*G0_0_1 + 0.50000000*G0_1_0 + 0.50000000*G0_1_1;
    A[1] = 0.16666667*G0_0_0 + 0.16666667*G0_1_0;
    A[2] = 0.16666667*G0_0_1 + 0.16666667*G0_1_1;
    A[3] = 0.00000000;
    A[4] = -0.66666667*G0_0_1 - 0.66666667*G0_1_1;
    A[5] = -0.66666667*G0_0_0 - 0.66666667*G0_1_0;
    A[6] = 0.16666667*G0_0_0 + 0.16666667*G0_0_1;
    A[7] = 0.50000000*G0_0_0;
    A[8] = -0.16666667*G0_0_1;
    A[9] = 0.66666667*G0_0_1;
    A[10] = 0.00000000;
    A[11] = -0.66666667*G0_0_0 - 0.66666667*G0_0_1;
    A[12] = 0.16666667*G0_1_0 + 0.16666667*G0_1_1;
    A[13] = -0.16666667*G0_1_0;
    A[14] = 0.50000000*G0_1_1;
    A[15] = 0.66666667*G0_1_0;
    A[16] = -0.66666667*G0_1_0 - 0.66666667*G0_1_1;
    A[17] = 0.00000000;
    A[18] = 0.00000000;
    A[19] = 0.66666667*G0_1_0;
    A[20] = 0.66666667*G0_0_1;
    A[21] = 1.33333333*G0_0_0 + 0.66666667*G0_0_1 + 0.66666667*G0_1_0 + 1.33333333*G0_1_1;
    A[22] = -1.33333333*G0_0_0 - 0.66666667*G0_0_1 - 0.66666667*G0_1_0;
    A[23] = -0.66666667*G0_0_1 - 0.66666667*G0_1_0 - 1.33333333*G0_1_1;
    A[24] = -0.66666667*G0_1_0 - 0.66666667*G0_1_1;
    A[25] = 0.00000000;
    A[26] = -0.66666667*G0_0_1 - 0.66666667*G0_1_1;
    A[27] = -1.33333333*G0_0_0 - 0.66666667*G0_0_1 - 0.66666667*G0_1_0;
    A[28] = 1.33333333*G0_0_0 + 0.66666667*G0_0_1 + 0.66666667*G0_1_0 + 1.33333333*G0_1_1;
    A[29] = 0.66666667*G0_0_1 + 0.66666667*G0_1_0;
    A[30] = -0.66666667*G0_0_0 - 0.66666667*G0_0_1;
    A[31] = -0.66666667*G0_0_0 - 0.66666667*G0_1_0;
    A[32] = 0.00000000;
    A[33] = -0.66666667*G0_0_1 - 0.66666667*G0_1_0 - 1.33333333*G0_1_1;
    A[34] = 0.66666667*G0_0_1 + 0.66666667*G0_1_0;
    A[35] = 1.33333333*G0_0_0 + 0.66666667*G0_0_1 + 0.66666667*G0_1_0 + 1.33333333*G0_1_1;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class spatialcoordinates_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  spatialcoordinates_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W4[4] = {0.15902069, 0.09097931, 0.15902069, 0.09097931};
    // Quadrature points on the UFC reference element: (0.17855873, 0.15505103), (0.07503111, 0.64494897), (0.66639025, 0.15505103), (0.28001992, 0.64494897)
    
    // Value of basis functions at quadrature points.
    static const double FE0[4][6] = \
    {{0.22176167, -0.11479229, -0.10696938, 0.11074286, 0.41329796, 0.47595918},
    {-0.12319761, -0.06377178, 0.18696938, 0.19356495, 0.72239423, 0.08404082},
    {-0.11479229, 0.22176167, -0.10696938, 0.41329796, 0.11074286, 0.47595918},
    {-0.06377178, -0.12319761, 0.18696938, 0.72239423, 0.19356495, 0.08404082}};
    
    static const double FEA4_f0[4][3] = \
    {{0.66639025, 0.17855873, 0.15505103},
    {0.28001992, 0.07503111, 0.64494897},
    {0.17855873, 0.66639025, 0.15505103},
    {0.07503111, 0.28001992, 0.64494897}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 6; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    
    // Declare array to hold physical coordinate of quadrature point.
    double X4[2];
    // Number of operations to compute element tensor for following IP loop = 352
    for (unsigned int ip = 0; ip < 4; ip++)
    {
      
      // Compute physical coordinate of quadrature point, operations: 10.
      X4[0] = FEA4_f0[ip][0]*x[0][0] + FEA4_f0[ip][1]*x[1][0] + FEA4_f0[ip][2]*x[2][0];
      X4[1] = FEA4_f0[ip][0]*x[0][1] + FEA4_f0[ip][1]*x[1][1] + FEA4_f0[ip][2]*x[2][1];
      
      // Number of operations for primary indices: 78
      for (unsigned int j = 0; j < 6; j++)
      {
        // Number of operations to compute entry: 13
        A[j] += FE0[ip][j]*(10.00000000*(std::exp((-1.00000000)*((((X4[0] + -0.50000000))*((X4[0] + -0.50000000)) + ((X4[1] + -0.50000000))*((X4[1] + -0.50000000))))/(0.02000000))))*W4[ip]*det;
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class spatialcoordinates_exterior_facet_integral_1_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  spatialcoordinates_exterior_facet_integral_1_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_exterior_facet_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet][0];
    const unsigned int v1 = edge_vertices[facet][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = x[v1][0] - x[v0][0];
    const double dx1 = x[v1][1] - x[v0][1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    // Array of quadrature weights.
    static const double W2[2] = {0.50000000, 0.50000000};
    // Quadrature points on the UFC reference element: (0.21132487), (0.78867513)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0[2][6] = \
    {{0.00000000, 0.45534180, -0.12200847, 0.66666667, 0.00000000, 0.00000000},
    {0.00000000, -0.12200847, 0.45534180, 0.66666667, 0.00000000, 0.00000000}};
    
    static const double FE0_f1[2][6] = \
    {{0.45534180, 0.00000000, -0.12200847, 0.00000000, 0.66666667, 0.00000000},
    {-0.12200847, 0.00000000, 0.45534180, 0.00000000, 0.66666667, 0.00000000}};
    
    static const double FE0_f2[2][6] = \
    {{0.45534180, -0.12200847, 0.00000000, 0.00000000, 0.00000000, 0.66666667},
    {-0.12200847, 0.45534180, 0.00000000, 0.00000000, 0.00000000, 0.66666667}};
    
    static const double FEA2_f0[2][3] = \
    {{0.00000000, 0.78867513, 0.21132487},
    {0.00000000, 0.21132487, 0.78867513}};
    
    static const double FEA2_f1[2][3] = \
    {{0.78867513, 0.00000000, 0.21132487},
    {0.21132487, 0.00000000, 0.78867513}};
    
    static const double FEA2_f2[2][3] = \
    {{0.78867513, 0.21132487, 0.00000000},
    {0.21132487, 0.78867513, 0.00000000}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 6; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    switch (facet)
    {
    case 0:
      {
        // Total number of operations to compute element tensor (from this point): 80
      
      // Loop quadrature points for integral.
      
      // Declare array to hold physical coordinate of quadrature point.
      double X2[2];
      // Number of operations to compute element tensor for following IP loop = 80
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Compute physical coordinate of quadrature point, operations: 10.
        X2[0] = FEA2_f0[ip][0]*x[0][0] + FEA2_f0[ip][1]*x[1][0] + FEA2_f0[ip][2]*x[2][0];
        X2[1] = FEA2_f0[ip][0]*x[0][1] + FEA2_f0[ip][1]*x[1][1] + FEA2_f0[ip][2]*x[2][1];
        
        // Number of operations for primary indices: 30
        for (unsigned int j = 0; j < 6; j++)
        {
          // Number of operations to compute entry: 5
          A[j] += FE0_f0[ip][j]*std::sin(5.00000000*X2[0])*W2[ip]*det;
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 1:
      {
        // Total number of operations to compute element tensor (from this point): 80
      
      // Loop quadrature points for integral.
      
      // Declare array to hold physical coordinate of quadrature point.
      double X2[2];
      // Number of operations to compute element tensor for following IP loop = 80
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Compute physical coordinate of quadrature point, operations: 10.
        X2[0] = FEA2_f1[ip][0]*x[0][0] + FEA2_f1[ip][1]*x[1][0] + FEA2_f1[ip][2]*x[2][0];
        X2[1] = FEA2_f1[ip][0]*x[0][1] + FEA2_f1[ip][1]*x[1][1] + FEA2_f1[ip][2]*x[2][1];
        
        // Number of operations for primary indices: 30
        for (unsigned int j = 0; j < 6; j++)
        {
          // Number of operations to compute entry: 5
          A[j] += FE0_f1[ip][j]*std::sin(5.00000000*X2[0])*W2[ip]*det;
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 2:
      {
        // Total number of operations to compute element tensor (from this point): 80
      
      // Loop quadrature points for integral.
      
      // Declare array to hold physical coordinate of quadrature point.
      double X2[2];
      // Number of operations to compute element tensor for following IP loop = 80
      for (unsigned int ip = 0; ip < 2; ip++)
      {
        
        // Compute physical coordinate of quadrature point, operations: 10.
        X2[0] = FEA2_f2[ip][0]*x[0][0] + FEA2_f2[ip][1]*x[1][0] + FEA2_f2[ip][2]*x[2][0];
        X2[1] = FEA2_f2[ip][0]*x[0][1] + FEA2_f2[ip][1]*x[1][1] + FEA2_f2[ip][2]*x[2][1];
        
        // Number of operations for primary indices: 30
        for (unsigned int j = 0; j < 6; j++)
        {
          // Number of operations to compute entry: 5
          A[j] += FE0_f2[ip][j]*std::sin(5.00000000*X2[0])*W2[ip]*det;
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    }
    
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class spatialcoordinates_form_0: public ufc::form
{
public:

  /// Constructor
  spatialcoordinates_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_finite_element_0();
        break;
      }
    case 1:
      {
        return new spatialcoordinates_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_dof_map_0();
        break;
      }
    case 1:
      {
        return new spatialcoordinates_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class spatialcoordinates_form_1: public ufc::form
{
public:

  /// Constructor
  spatialcoordinates_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~spatialcoordinates_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), Product(FloatValue(10.0, (), (), {}), exp(Division(Product(IntValue(-1, (), (), {}), Sum(Power(Sum(FloatValue(-0.5, (), (), {}), Indexed(SpatialCoordinate(Cell('triangle', 1, Space(2))), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))), IntValue(2, (), (), {})), Power(Sum(FloatValue(-0.5, (), (), {}), Indexed(SpatialCoordinate(Cell('triangle', 1, Space(2))), MultiIndex((FixedIndex(1),), {FixedIndex(1): 2}))), IntValue(2, (), (), {})))), FloatValue(0.02, (), (), {}))))), Measure('cell', 0, None)), Integral(Product(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 2), 0), sin(Product(FloatValue(5.0, (), (), {}), Indexed(SpatialCoordinate(Cell('triangle', 1, Space(2))), MultiIndex((FixedIndex(0),), {FixedIndex(0): 2}))))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 1;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new spatialcoordinates_exterior_facet_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
