/*  SearchMethod.java
 Copyright (C) 2004 Juhani Rautiainen

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
import java.io.IOException;
import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;

public class SearchMethod extends EntityEnclosingMethod {

	private String body;

	public SearchMethod(String path) {
		super(path);
	}

	public String getName() {
		return "SEARCH";
	}

	public void addRequestHeaders(HttpState state, HttpConnection conn)
			throws IOException, HttpException {
		if (getRequestHeader("Content-Type") == null)
			super.setRequestHeader("Content-Type", "text/xml");
		super.addRequestHeaders(state, conn);
		super.setRequestHeader("Range", "rows=0-99");
		super.setRequestHeader("Brief", "t");
	}
}
