/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;

public class ArraySequence
extends ArrayStructure {
    private StructureDataIterator iter;
    private int initial = 1000;

    protected ArraySequence(StructureMembers sm, int[] shape) {
        super(sm, shape);
    }

    public ArraySequence(StructureMembers members, StructureDataIterator iter, int nelems) {
        super(members, new int[]{0});
        this.iter = iter;
        this.nelems = nelems;
    }

    public Class getElementType() {
        return StructureDataIterator.class;
    }

    public StructureDataIterator getStructureDataIterator() throws IOException {
        this.iter = this.iter.reset();
        return this.iter;
    }

    public int getStructureDataCount() {
        return this.nelems;
    }

    public long getSizeBytes() {
        return this.nelems * this.members.getStructureSize();
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    public Array extractMemberArray(StructureMembers.Member proxym) throws IOException {
        Array result;
        if (proxym.getDataArray() != null) {
            return proxym.getDataArray();
        }
        DataType dataType = proxym.getDataType();
        boolean isScalar = proxym.getSize() == 1 || dataType == DataType.SEQUENCE;
        int[] mshape = proxym.getShape();
        int rrank = 1 + mshape.length;
        int[] rshape = new int[rrank];
        rshape[0] = this.nelems;
        System.arraycopy(mshape, 0, rshape, 1, mshape.length);
        if (this.nelems < 0) {
            return this.extractMemberArrayFromIteration(proxym, rshape);
        }
        if (dataType == DataType.STRUCTURE) {
            StructureMembers membersw = new StructureMembers(proxym.getStructureMembers());
            result = new ArrayStructureW(membersw, rshape);
        } else {
            result = Array.factory(dataType.getPrimitiveClassType(), rshape);
        }
        StructureDataIterator sdataIter = this.getStructureDataIterator();
        IndexIterator resultIter = result.getIndexIterator();
        while (sdataIter.hasNext()) {
            Object[] data;
            StructureData sdata = sdataIter.next();
            StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
            if (isScalar) {
                if (dataType == DataType.DOUBLE) {
                    resultIter.setDoubleNext(sdata.getScalarDouble(realm));
                    continue;
                }
                if (dataType == DataType.FLOAT) {
                    resultIter.setFloatNext(sdata.getScalarFloat(realm));
                    continue;
                }
                if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                    resultIter.setByteNext(sdata.getScalarByte(realm));
                    continue;
                }
                if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                    resultIter.setShortNext(sdata.getScalarShort(realm));
                    continue;
                }
                if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                    resultIter.setIntNext(sdata.getScalarInt(realm));
                    continue;
                }
                if (dataType == DataType.LONG) {
                    resultIter.setLongNext(sdata.getScalarLong(realm));
                    continue;
                }
                if (dataType == DataType.CHAR) {
                    resultIter.setCharNext(sdata.getScalarChar(realm));
                    continue;
                }
                if (dataType == DataType.STRING) {
                    resultIter.setObjectNext(sdata.getScalarString(realm));
                    continue;
                }
                if (dataType == DataType.STRUCTURE) {
                    resultIter.setObjectNext(sdata.getScalarStructure(realm));
                    continue;
                }
                if (dataType != DataType.SEQUENCE) continue;
                resultIter.setObjectNext(sdata.getArraySequence(realm));
                continue;
            }
            if (dataType == DataType.DOUBLE) {
                for (double aData : data = sdata.getJavaArrayDouble(realm)) {
                    resultIter.setDoubleNext(aData);
                }
                continue;
            }
            if (dataType == DataType.FLOAT) {
                for (double aData : data = (Object[])sdata.getJavaArrayFloat(realm)) {
                    resultIter.setFloatNext((float)aData);
                }
                continue;
            }
            if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                for (double aData : data = (Object[])sdata.getJavaArrayByte(realm)) {
                    resultIter.setByteNext((byte)aData);
                }
                continue;
            }
            if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                for (double aData : data = (Object[])sdata.getJavaArrayShort(realm)) {
                    resultIter.setShortNext((short)aData);
                }
                continue;
            }
            if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                for (double aData : data = (Object[])sdata.getJavaArrayInt(realm)) {
                    resultIter.setIntNext((int)aData);
                }
                continue;
            }
            if (dataType == DataType.LONG) {
                for (double aData : data = (Object[])sdata.getJavaArrayLong(realm)) {
                    resultIter.setLongNext((long)aData);
                }
                continue;
            }
            if (dataType == DataType.CHAR) {
                for (double aData : data = (Object[])sdata.getJavaArrayChar(realm)) {
                    resultIter.setCharNext((char)aData);
                }
                continue;
            }
            if (dataType == DataType.STRING) {
                for (double aData : data = (Object[])sdata.getJavaArrayString(realm)) {
                    resultIter.setObjectNext(aData);
                }
                continue;
            }
            if (dataType != DataType.STRUCTURE) continue;
            ArrayStructure as = sdata.getArrayStructure(realm);
            StructureDataIterator innerIter = as.getStructureDataIterator();
            while (innerIter.hasNext()) {
                resultIter.setObjectNext(innerIter.next());
            }
        }
        return result;
    }

    private Array extractMemberArrayFromIteration(StructureMembers.Member proxym, int[] rshape) throws IOException {
        DataType dataType = proxym.getDataType();
        StructureDataIterator sdataIter = this.getStructureDataIterator();
        Object[] dataArray = null;
        int count = 0;
        if (dataType == DataType.DOUBLE) {
            ArrayList<Double> result = new ArrayList<Double>(this.initial);
            while (sdataIter.hasNext()) {
                double[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (double aData : data = sdata.getJavaArrayDouble(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            double[] da = new double[result.size()];
            int i = 0;
            for (Double d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.FLOAT) {
            ArrayList<Float> result = new ArrayList<Float>(this.initial);
            while (sdataIter.hasNext()) {
                float[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (float aData : data = sdata.getJavaArrayFloat(realm)) {
                    result.add(Float.valueOf(aData));
                }
                ++count;
            }
            float[] da = new float[result.size()];
            int i = 0;
            for (Float d : result) {
                da[i++] = d.floatValue();
            }
            dataArray = da;
        } else if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
            ArrayList<Byte> result = new ArrayList<Byte>(this.initial);
            while (sdataIter.hasNext()) {
                byte[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (byte aData : data = sdata.getJavaArrayByte(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            byte[] da = new byte[result.size()];
            int i = 0;
            for (Byte d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            ArrayList<Short> result = new ArrayList<Short>(this.initial);
            while (sdataIter.hasNext()) {
                short[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (short aData : data = sdata.getJavaArrayShort(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            short[] da = new short[result.size()];
            int i = 0;
            for (Short d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            ArrayList<Integer> result = new ArrayList<Integer>(this.initial);
            while (sdataIter.hasNext()) {
                int[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (int aData : data = sdata.getJavaArrayInt(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            int[] da = new int[result.size()];
            int i = 0;
            for (Integer d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.LONG) {
            ArrayList<Long> result = new ArrayList<Long>(this.initial);
            while (sdataIter.hasNext()) {
                long[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (long aData : data = sdata.getJavaArrayLong(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            long[] da = new long[result.size()];
            int i = 0;
            for (Long d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.CHAR) {
            ArrayList<Character> result = new ArrayList<Character>(this.initial);
            while (sdataIter.hasNext()) {
                char[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (char aData : data = sdata.getJavaArrayChar(realm)) {
                    result.add(Character.valueOf(aData));
                }
                ++count;
            }
            char[] da = new char[result.size()];
            int i = 0;
            for (Character d : result) {
                da[i++] = d.charValue();
            }
            dataArray = da;
        } else if (dataType == DataType.STRING) {
            ArrayList<String> result = new ArrayList<String>(this.initial);
            while (sdataIter.hasNext()) {
                String[] data;
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                for (String aData : data = sdata.getJavaArrayString(realm)) {
                    result.add(aData);
                }
                ++count;
            }
            String[] da = new String[result.size()];
            int i = 0;
            for (String d : result) {
                da[i++] = d;
            }
            dataArray = da;
        } else if (dataType == DataType.STRUCTURE) {
            ArrayList<StructureData> result = new ArrayList<StructureData>(this.initial);
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                ArrayStructure as = sdata.getArrayStructure(realm);
                StructureDataIterator innerIter = as.getStructureDataIterator();
                while (innerIter.hasNext()) {
                    result.add(innerIter.next());
                }
                ++count;
            }
            StructureData[] da = new StructureData[result.size()];
            rshape[0] = count;
            StructureMembers membersw = new StructureMembers(proxym.getStructureMembers());
            return new ArrayStructureW(membersw, rshape, da);
        }
        rshape[0] = count;
        return Array.factory(dataType.getPrimitiveClassType(), rshape, (Object)dataArray);
    }

    public String toString() {
        return Integer.toString(this.nelems);
    }
}

