/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;

class PktHeaderBitReader {
    RandomAccessIO in;
    ByteArrayInputStream bais;
    boolean usebais;
    int bbuf;
    int bpos;
    int nextbbuf;

    PktHeaderBitReader(RandomAccessIO in) {
        this.in = in;
        this.usebais = false;
    }

    PktHeaderBitReader(ByteArrayInputStream bais) {
        this.bais = bais;
        this.usebais = true;
    }

    final int readBit() throws IOException {
        if (this.bpos == 0) {
            if (this.bbuf != 255) {
                this.bbuf = this.usebais ? this.bais.read() : this.in.read();
                this.bpos = 8;
                if (this.bbuf == 255) {
                    this.nextbbuf = this.usebais ? this.bais.read() : this.in.read();
                }
            } else {
                this.bbuf = this.nextbbuf;
                this.bpos = 7;
            }
        }
        return this.bbuf >> --this.bpos & 1;
    }

    final int readBits(int n) throws IOException {
        if (n <= this.bpos) {
            return this.bbuf >> (this.bpos -= n) & (1 << n) - 1;
        }
        int bits = 0;
        do {
            bits <<= this.bpos;
            n -= this.bpos;
            bits |= this.readBits(this.bpos);
            if (this.bbuf != 255) {
                this.bbuf = this.usebais ? this.bais.read() : this.in.read();
                this.bpos = 8;
                if (this.bbuf != 255) continue;
                if (this.usebais) {
                    this.nextbbuf = this.bais.read();
                    continue;
                }
                this.nextbbuf = this.in.read();
                continue;
            }
            this.bbuf = this.nextbbuf;
            this.bpos = 7;
        } while (n > this.bpos);
        bits <<= n;
        return bits |= this.bbuf >> (this.bpos -= n) & (1 << n) - 1;
    }

    void sync() {
        this.bbuf = 0;
        this.bpos = 0;
    }

    void setInput(RandomAccessIO in) {
        this.in = in;
        this.bbuf = 0;
        this.bpos = 0;
    }

    void setInput(ByteArrayInputStream bais) {
        this.bais = bais;
        this.bbuf = 0;
        this.bpos = 0;
    }
}

