#include "triton.h"

int triton_init(void) {
   //printf("Welcome to Triton!\n");
   //printf("TRITON: ::init...\n");
   __triton_low_init();
   return 0;
}

void triton_deinit(void) {
   //printf("TRITON: ::deinit...\n");
   __triton_low_deinit();
}

void *triton_open(const char *file) {
   //printf("TRITON ::open...\n");
   return __triton_low_open(file);
}

void *triton_openext(const char *file) {
   char *tmp = NULL;
   char *ext = 0;
   void *handle;
   const char *mext = __triton_low_module_ext();

   
   if(!file) {
      return triton_open(file);
   }

   ext = strrchr(file, '.');
   if(ext && ((strcmp (ext, mext) == 0))) {
      return triton_open(file);
   }

   tmp = malloc(strlen(file) + strlen(mext) +1);
   strcpy(tmp, file);
   strcat(tmp, mext);

   /* so now go ahead and try to open it, then check for errors */
   handle = triton_open(tmp);
   if(handle) {
      free(tmp);
      return handle;
   }

   /* giving up, couldnt find it */
   // ferite_error(NULL, "File not found: '%s' (lib error: '%s')\n",file, __ferite_lib_error());
   return NULL;
}

void *triton_getsym(void *h, const char *f) {
   //printf("::getsym ('%s')\n",f);
   return __triton_low_getsym(h,f);
}

int triton_close(void *h) {
   return __triton_low_close(h);
}

const char *triton_error(void) {
   return __triton_low_error();
}
