#line 260 "interscript/src/utf8.ipk"
import string

def ucs4le(i):
  return
    chr(i & 0xFF) +\
    chr((i >> 8) & 0xFF) +\
    chr((i >> 16) & 0xFF) +\
    chr((i >> 24) & 0xFF)

def seq_to_ucs2le(a):
  s = ''
  for ch in a: s = s + ucs4le(ch)
  return s

# decoding
def parse_ucs4le(s, i):
  return \
    (ord(s[i+3]) << 24) +\
    (ord(s[i+2]) << 16) +\
    (ord(s[i+1]) << 8) +\
    ord(s[i]) , i+4

def ucs4_to_array(s):
  n = len(s)
  a = array('H',(0,)*n/4)
  i = 0
  while i < n:
    a[i/4],i = parse_ucs4le(s,i)

def ucs4le_to_utf8(s):
  return seq_to_utf8(ucs4le_to_array(s))


