\name{RmetricsData}

\alias{RmetricsData}

%\alias{ciaFactbook}
\alias{CPI.dat}
\alias{dem2gbp}
\alias{DowJones30}
\alias{ford.s}
\alias{hp.s}
\alias{IP.dat}
\alias{klein}
\alias{kmenta}
\alias{msft.dat}
\alias{nelsonplosser}
\alias{nyse}
\alias{recession}
\alias{shiller.dat}
\alias{shiller.annual}
\alias{singleIndex.dat}
\alias{sp500dge}
\alias{sp500index}
\alias{surex1.ts}
\alias{usdchf}
\alias{usdthb}
%\alias{wfe1..6}
\alias{yhoo.df}

\title{Rmetrics Data Sets} 


\description{

    A collection and description of data sets 
    used in example of the Rmetrics packages.
    \cr
       
    \code{CPI.dat}\cr
    \code{IP.dat}
    \cr\cr
    The file \code{"IP.dat.csv"} contains data representing seasonally 
    adjusted US Industrial Production Index and the file 
    \code{"CPI.dat.csv"} contains data representing seasonally 
    adjusted US Consumer Price Index. 
    \cr
    
    \code{dem2gbp}
    \cr
    The file \code{"dem2gbp.csv"} contains daily observations of the 
    Deutschmark / British Pound foreign exchange log returns. 
    This data set has been promoted as an informal benchmark 
    for GARCH time-series software validation. See McCullough and 
    Renfro [1991], and Brooks, Burke, and Persand (2001) for details.
    The nominal returns are expressed in percent, as published in 
    Bollerslev and Ghysels (2001). The data set is available from 
    the \emph{Journal of Business and Economic Statistics}, (JBES), 
    \emph{ftp://www.amstat.org}. A text file has one column of 
    data listing the percentual log-returns of the DEM/GBP exchange 
    rates. The sample period is from January 3, 1984, to December 
    31, 1991, for a total of 1975 daily observations of FX exchange 
    rates.
    \cr 
    
    \code{DowJones30}
    \cr
    The file \code{"DowJones30.csv"} contains daily observations from 
    January 2, 1991 to January 2, 2001, of the 30 constitutents of 
    the Dow Jones Index. Each of the thirty columns represents the 
    closing price of a stock in the "Dow Jones Industrial Average".
    \cr 
       
    \code{ford.s}\cr
    \code{hp.s}
    \cr\cr
    The files \code{"ford.s.csv"} and \code{"hp.s.csv"} contain data 
    representing 2000 daily stock returns for the Ford and HP shares 
    traded at NYSE. The time series span the period from Feburary 2, 
    1984, to December 31, 1991. 
    \cr
    
    \code{klein}
    \cr
    The file \code{"klein.csv"} contains data for Klein's (1950) simple 
    econometric model of the US economy. The Klein data frame has 
    22 rows and 10 columns: \cr
    This data frame contains the following columns: 
    \code{year} years 1921-1941, represented in the POSIX data format 
        \%Y-\%m-\%d,  \cr
    \code{c} the consumption, \cr 
    \code{p} the private profits, \cr
    \code{wp} the private wages, \cr
    \code{i} the investment, \cr 
    \code{k.lag} the capital stock, lagged one year, \cr 
    \code{x} the equilibrium demand, \cr 
    \code{wg} the government wages, \cr
    \code{g} the government non-wage spending, \cr 
    \code{tax} indirect business taxes and net exports. \cr
    Source: Greene (1993)
    \cr
     
    \code{kmenta}
    \cr
    The file \code{"kmenta.csv"} contains partly contrived data from 
    Kmenta (1986), constructed to illustrate estimation of a 
    simultaneous-equation model. The data set has 20 rows and 6 columns, 
    where the first holds the ISO-8601 formatted date as "\%Y-\%m-\%d": 
    The remaining columns are: \cr
    \code{q} food consumption per capita, \cr
    \code{p} ratio of food prices to general consumer prices, \cr
    \code{d} disposable income in constant dollars, \cr
    \code{f} ratio of preceding year's prices received by farmers 
        to general consumer prices, \cr
    \code{a} time in years (numbered from 1 to 20). \cr
    The exogenous variables \code{d}, \code{f}, and \code{a} are based 
    on real data; the endogenous variables \code{p} and \code{q} were 
    generated by simulation. 
    \cr
    
    \code{msft.dat}
    \cr
    The file \code{"msft.dat.csv"} contains daily stock prices and volumes for
    the the Microsoft covering the period from 2000-09-27 until 2001-09-27.
    The first column lists dates in the format code{"\%Y-\%m-\%d"}, the 
    next four columns Open, High, Low, and Close Prices, and the final 
    column volumes.
    \cr 
  
    \code{nelsonplosser}
    \cr
    The file \code{"nelsonplotter.csv"} contains the data set listing 
    fourteen US economic time series used by Nelson and Plosser in their 
    seminal paper. The time series are: \cr
    \code{"\%Y\%m\%d"} - Date index from 18601231 until 19701231, \cr 
    \code{"gnp.r"} - Real GNP, [Billions of 1958 Dollars], [1909 - 1970], \cr 
    \code{"gnp.n"} - Nominal GNP, [Millions of Current Dollars], 
        [1909 - 1970], \cr 
    \code{"gnp.pc"} - Real Per Capita GNP, [1958 Dollars], [1909 - 1970], \cr  
    \code{"ip"} - Industrial Production Index, [1967 = 100], [1860 - 1970], \cr  
    \code{"emp"} - Total Employment, [Thousands], [1890 - 1970], \cr  
    \code{"ur"} - Total Unemployment Rate, [Percent], [1890 - 1970], \cr  
    \code{"gnp.p"} - GNP Deflator, [1958 = 100], [1889 - 1970], \cr  
    \code{"cpi"} - Consumer Price Index, [1967 = 100], [1860 - 1970], \cr  
    \code{"wg.n"} - Nominal Wages, [current Dollars], [1900 - 1970], \cr  
    \code{"wg.r"} - Real Wages, [Nominal wages/CPI], [1900 - 1970], \cr  
    \code{"M"} - Money Stock (M2), [Billions of Dollars, annual averages], 
        [1889 - 1970], \cr  
    \code{"vel"} - Velocity of Money, [1869 - 1970], \cr  
    \code{"bnd"} - Basic Bond Yields of 30-year Corporate Bonds, 
        [Percent per annum], [1900 - 1970], \cr 
    \code{"sp"} - Stock Prices, [Index; 1941 - 43 = 100], [1871 - 1970].
    \cr
      
    \code{nyse}
    \cr
    The file \code{"nyse.csv"} archives a two-column dataset, the first
    contains the date in the format \code{"\%Y\%m-\%d"} and the second
    daily records of the NYSE Composite Index.
    \cr
    
    \code{recession}
    \cr
    The file \code{"recession.csv"} holds the data set used in the regression 
    analysis of US recession.
    The data include short and long term interest rates from the US,
    the 3 Month Tbills data from US FED,
    the 10 Year Tbonds data from US FED, and also the 
    Stock-Watson experimental recession index.
    \cr  
        
    \code{shiller.dat}\cr
    \code{shiller.annual}
    \cr
    The files \code{"shiller.dat.csv"} and \code{"shiller.annual.csv"} hold
    data used in the book "Irrational Exuberance" by Robert Shiller. The 
    data are 
    \code{price} - monthly nominal US SP stock market prices,
    \code{dividend} - nominal SP Composite Index dividends,
    \code{earnings} - nominal SP Composite Index earnings,
    \code{cpi} - US Consumer Price Indexes,
    \code{real.price} - real US stock market prices,
    \code{real.dividend} - real SP Composite Index dividends,
    \code{real.earnings} - real SP Composite Index earnings,
    \code{pe.10} - price-earnings ratios,
    \code{dp.ratio} - dividend-price ratios,
    \code{dp.yield} - dividend-price yield. The last two are only 
    listed in \code{shiller.annual}.
    The series start January 1871 and end on March 2001.
    \cr
    
    \code{singleIndex.dat}
    \cr
    The file \code{"recession.csv"} holds monthly index and price data 
    records from January 1990 to January 2001. Included are monthly closing 
    prices for Microsoft Corporation (MSFT) and SP500 Index (SP500).
    \cr
    
    \code{sp500dge}\cr
    \code{sp500index}
    \cr
    The first file \code{"sp500index.csv"} lists daily SP500 index values. 
    The data cover the period January 1995 until December 1999, and 
    have 1249 observations. The first column of the file lists 
    dates, and the second column lists index values. The second file
    \code{"sp500dge.csv"} lists daily returns from the SP500 as used in 
    the paper of Ding, Granger and Engle.
    \cr
    
    \code{surex1.ts.dat}
    \cr 
    The file \code{"surex1.ts.csv"} contains exchange rate spot returns 
    and forward premium data as used in the article of E. Zivot (2000).
  
    \code{yhoo.df}
    \cr 
    The file \code{"yhoo.df.csv"} contains data representing daily 
    transaction information of Yahoo stock, with the following 
    six columns: Date, Open, High, Low, Close, Volume.
}


\format{
    
    All files are in CSV Excel spreadsheet format. The
    delimiter is a semicolon. 
    
}


\references{

Berndt E.R. (1991);
    \emph{The Practice of Econometrics: Classic and Contemporary},
    Addison-Wesley Publishing Co. 
    
Box G.E.P., Jenkins J.M. (1976);
    \emph{Time Series Analysis: Forecasting and Control},
    Holden Day, San Francisco.

Brooks C., Burke S.P., Persand G. (2001);
    \emph{Benchmarks and the Accuracy of GARCH Model Estimation},
    International Journal of Forecasting 17, 45--56.

Ding Z., Granger C.W.J., Engle R.F. (1993);
    \emph{A Long Memory Property of Stock Market Returns And a New
    Model},
    Journal of Empirical Finance 1, 83--106.
    
McCullough B.D., Renfro C.G. (1998);
    \emph{Benchmarks and Software Standards: A Case Study of GARCH 
    Procedures},
    Journal of Economic and Social Measurement 25, 59--71. 
    
Greene W.H. (1993);
    \emph{Econometric Analysis},
    Second Edition, Macmillan. 

Klein, L. (1950);
     \emph{Economic Fluctuations in the United States 1921--1941},
     Wiley. 

Kmenta J. (1997); 
    \emph{Elements of Econometrics}, 
    Second Edition, University of Michigan Publishing. 
    
Laurent S., Peters J.P. (2002); 
    \emph{G@RCH 2.2: An Ox Package for Estimating and Forecasting  
    Various ARCH Models}, 
    Journal of Economic Surveys 16, 447--485. 
    
Nelson C.R., Plosser C.I. (1982); 
    \emph{Trends and Random Walks in Macroeconomic Time Series},
    Journal of Monetary Economics, 10, 139--162. 

Zivot E. (2000);
    \emph{Cointegration and forward and spot exchange rate regressions},
    Journal of International Money and Finance 19, 785--812, and 387--401. 

}
 
 
\keyword{datasets}

