/*
   canonicalize.c: resolve file name 
   This file is part of fbgetty
   Copyright (C) 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>.

   fbgetty is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   fbgetty is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <fbgetty/global.h>

#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <string.h>

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#ifndef HAVE_CANONICALIZE_FILENAME 

#ifndef PATH_MAX
#define FBGETTY_PATH_MAX 4096
#endif

char *
canonicalize_filename (const char *filename)
{
  char *realfilename;

#ifdef HAVE_CANONICALIZE_FILE_NAME
  /* Use the GLIBC function */
  realfilename = canonicalize_file_name(filename);
#else
#ifdef HAVE_REALPATH
  /* Use the BSD realpath () 
     Be careful about buffer overflow */
  char *ret;
  long path_max;

#ifdef PATH_MAX
  path_max = PATH_MAX;
#else
#ifdef MAXPATHLEN
  path_max = MAXPATHLEN;
#else
#ifdef HAVE_PATHCONF
  path_max = pathconf (path, _PC_PATH_MAX);
  if (path_max <= 0)
    path_max = FBGETTY_PATH_MAX;
#else
    path_max = FBGETTY_PATH_MAX;
#endif /* HAVE_PATHCONF */
#endif /* MAXPATHLEN */
#endif /* PATH_MAX */
 
  realfilename = (char *) malloc((path_max + 1) * sizeof(char));
  if (realfilename != NULL)
    {
      ret = realpath(filename, realfilename);
      if (ret != NULL)
	{
	  long size;
	  
	  size = strlen(realfilename);
	  if (size != path_max)
	    {
	      ret = (char *) realloc(realfilename,(size + 1) * sizeof(char));
	      if (ret != NULL)
		realfilename = ret;
	    }

	}
      else
	free(realfilename);
    }
#else
  /* no function to resolve a filename
     XXX write one */
  realfilename = strdup(filename);

#endif /* HAVE_REALPATH */
#endif /* HAVE_CANONICALIZE_FILENAME */

  return(realfilename);
}
#endif /* HAVE_CANONICALIZE_FILENAME */
