/*
 * $Id: serial_modem_gui_gtk.c,v 1.19 2009-06-03 11:34:11 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-switch.h"
#include "glue-gui-gtk-led.h"

#include "serial_modem_gui_gtk.h"

#define COMP "serial_modem"

struct cpssp {
	GtkWidget *_switch;
	GtkWidget *gui_online_led;
	GtkWidget *gui_rxd_led;
	GtkWidget *gui_txd_led;

	struct sig_boolean *port_switch;
};

/*
 * Simulator Callbacks
 */
static void
serial_modem_switch_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_switch_set(GUI_GTK_SWITCH(cpssp->_switch),
				(gboolean) val);
	gui_gtk_flush();
}

static void
serial_modem_gui_opt_online_led_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->gui_online_led), val);
        gui_gtk_flush();
}

static void
serial_modem_gui_opt_rxd_led_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->gui_rxd_led), val);
        gui_gtk_flush();
}

static void
serial_modem_gui_opt_txd_led_set(void *_cpssp, unsigned int val)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->gui_txd_led), val);
        gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
serial_modem_gui_switched_on_event(GtkWidget *w, gpointer _cpssp)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 1);
}

static void
serial_modem_gui_switched_off_event(GtkWidget *w, gpointer _cpssp)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_switch, cpssp, 0);
}

void *
serial_modem_gui_gtk_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_switch,
	struct sig_serial *port_serial,
	struct sig_telephone *port_phone,
	struct sig_boolean *port_opt_online_led,
	struct sig_boolean *port_opt_rxd_led,
	struct sig_boolean *port_opt_txd_led
)
{
	static const struct sig_boolean_funcs switch_funcs = {
                .set = serial_modem_switch_set,
	};
        static const struct sig_boolean_funcs opt_online_led_funcs = {
                .set = serial_modem_gui_opt_online_led_set,
        };
        static const struct sig_boolean_funcs opt_rxd_led_funcs = {
                .set = serial_modem_gui_opt_rxd_led_set,
        };
        static const struct sig_boolean_funcs opt_txd_led_funcs = {
                .set = serial_modem_gui_opt_txd_led_set,
        };
	struct cpssp *cpssp;
	GtkWidget *vbox;
	GtkWidget *hbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

        vbox = gtk_vbox_new(FALSE, 1);

        hbox = gtk_hbox_new(FALSE, 1);

        /* Online LED */
        cpssp->gui_online_led = gui_gtk_led_new("Online");
        gtk_widget_show(cpssp->gui_online_led);
        gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_online_led,
                        TRUE, FALSE, 1);

        /* RXD LED */
        cpssp->gui_rxd_led = gui_gtk_led_new("RXD");
        gtk_widget_show(cpssp->gui_rxd_led);
        gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_rxd_led,
                        TRUE, FALSE, 1);

        /* TXD LED */
        cpssp->gui_txd_led = gui_gtk_led_new("TXD");
        gtk_widget_show(cpssp->gui_txd_led);
        gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_txd_led,
                        TRUE, FALSE, 1);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 1);

	/* Power Switch */
	cpssp->_switch = gui_gtk_switch_new();
	g_signal_connect(G_OBJECT(cpssp->_switch), "switched-on",
			G_CALLBACK(serial_modem_gui_switched_on_event), cpssp);
	g_signal_connect(G_OBJECT(cpssp->_switch), "switched-off",
			G_CALLBACK(serial_modem_gui_switched_off_event), cpssp);
	gtk_widget_show(cpssp->_switch);
        gtk_box_pack_end(GTK_BOX(vbox), cpssp->_switch,
                        TRUE, FALSE, 1);

	gtk_widget_show(vbox);
        gui_gtk_comp_add(page, COMP, name, vbox, FALSE, FALSE, NULL);

	/* Out */
	cpssp->port_switch = port_switch;
	sig_boolean_connect_out(port_switch, cpssp, 0);

        /* In */
        sig_boolean_connect_in(port_switch, cpssp, &switch_funcs);
        sig_boolean_connect_in(port_opt_online_led, cpssp, &opt_online_led_funcs);
        sig_boolean_connect_in(port_opt_rxd_led, cpssp, &opt_rxd_led_funcs);
        sig_boolean_connect_in(port_opt_txd_led, cpssp, &opt_txd_led_funcs);

	return cpssp;
}

void
serial_modem_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
