/*
 * $Id: arch_gen_cpu_x86_mmu_fast.c,v 1.11 2009-11-06 14:53:19 vrsieh Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *
 *  Copyright (c) 2007-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

/*
 * Try to fill the TLB and return an exception if error. If retaddr is
 * NULL, it means that the function was called in C code (i.e. not
 * from generated code or from helper.c)
 */
/* XXX: fix it to restore all registers */
void
NAME_(tlb_fill)(Vaddr addr, int rwx, int is_user, void *retaddr)
{
	TranslationBlock *tb;
	int ret;
	unsigned long pc;

	ret = NAME_(mmu_fault)(addr, rwx, is_user);
	if (ret) {
		if (retaddr) {
			/* now we have a real cpu fault */
			pc = (unsigned long)retaddr;
			tb = NAME_(tb_find_pc)(pc);
			if (tb) {
				/*
				 * The PC is inside the translated code. It
				 * means that we have a virtual CPU fault
				 */
				NAME_(restore_state)(tb, pc);
			}
		}
		if (retaddr)
			NAME_(raise_exception_err)(CPU_FAULT_PF,
					env->error_code);
		else
			NAME_(raise_exception_err_norestore)(CPU_FAULT_PF,
					env->error_code);
	}
}

#define MMUSUFFIX _mmu
#define GETPC() (__builtin_return_address(0))

#define SHIFT 0
#include "arch_gen_cpu_x86_mmu_template.c"

#define SHIFT 1
#include "arch_gen_cpu_x86_mmu_template.c"

#define SHIFT 2
#include "arch_gen_cpu_x86_mmu_template.c"

#define SHIFT 3
#include "arch_gen_cpu_x86_mmu_template.c"

#undef GETPC
#undef MMUSUFFIX
