/*
	FATSort, utility for sorting FAT directory structures
	Copyright (C) 2004 Boris Leidner <fatsort(at)formenos.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	This file contains/describes functions for sorting of FAT filesystems.
*/

#ifndef __sort_h__
#define __sort_h__

#include <stdlib.h>
#include <sys/types.h>
#include "FAT_fs.h"

// sorts FAT file system
int32_t sort_fs(char *filename);

// sorts the root directory of a FAT16 file system
int32_t sort_FAT16_rootdir(FILE *fd, struct sBootSector *bs);

// sorts directory entries in a cluster
int32_t sortClusterChain(FILE *fd, struct sBootSector *bs, u_int32_t cluster, char *path);

#endif // __sort_h__
