/******************************************************************************

	conn.h -- create outgoing network connections
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: conn.h 23144 2007-12-21 15:36:48Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair-0.5.1/src/conn.h $

******************************************************************************/
#ifndef CONN_H
#define CONN_H

#include <sys/socket.h>
#include <avl.h>

#include "address.h"
#include "fd.h"

struct connector;

typedef void (*connect_hook_t)(struct connector *, fd_t *);

typedef struct connector {
	avl_node_t node;
	fd_t *fd;
	connect_hook_t func;
	void *data;
} connector_t;

extern unsigned int connector_count(void);
extern connector_t *connector_new(const address_t *, connect_hook_t, void *);
extern void connector_delete(connector_t *);

#endif
