/*
 * dcc.h
 * (C) 1999, 2000 Murat Deligonul
 *
 */
 
#ifndef __DCC_H
#define __DCC_H

#include <netinet/in.h>
#include <time.h>
#include "linkedlist.h"
#include "dynbuff.h"
#include "socket.h"

class conn;
class dccsend;
class dccpipe;
class dcc_list_t;

extern int check_timers(void);

class dcc 
{

protected:
    class dccsock : public pollsocket {
    public:
        dccsock(dcc * owner, int fd, int options)
         : pollsocket(fd, options)
        {
            this->owner = owner;
        }

        int event_handler(const struct pollfd * );

        dcc * owner;
        friend class dcc;
        friend class dccpipe;
        friend class dccsend;
    };

    struct dccinfo_t 
    {
         unsigned short port;
         unsigned long address;
         dccsock * sock;
         dynbuff * buffer;
     };

     friend class dccsock;
     friend int check_timers(void);
     
    dccinfo_t *sender, *receiver;
    dccsock * lsock;
     
    int stat;
    time_t start_time;
    static int num_waiting;
    
public:
    dcc(struct sockaddr_in *, unsigned short *);
    virtual ~dcc();
    dcc_list_t * dcc_list_entry;
    
protected:
    void close_all(void);

public:
    static int create_fd_set(linkedlist<dcc> *, fd_set *, fd_set *);
    static int check_fd_set(linkedlist<dcc> *, fd_set *, fd_set *, time_t);
    
    /*
     * This does the work for the dcc. Constants it can return 
     * are declared below.
     */
    virtual int poll(struct sockaddr_in *) = 0;
    
};

class dccpipe : public dcc
{
public:
    dccpipe(unsigned long, unsigned short, struct sockaddr_in * psin, unsigned short * listen_port);

    bool do_connect();           /* connect to the receiver of the dcc */
    bool on_connect(int);        /* when connection to receiver is established */
    bool on_disconnect(int);     /* when one of the parties dies */
    int  poll(struct sockaddr_in *);
};

/* 
 * Simple dcc send thing. Waits for connection and then sends.
 * Does not bother with IRC commands needed to initiate the send.
 */
class dccsend : public dcc
{
public:
    dccsend(const char * filename, struct sockaddr_in * psin, unsigned short *listen_port, unsigned long *);
    ~dccsend();
    int poll(struct sockaddr_in *);

private:
    int file;
    char * filename;
    unsigned long sent,          /* How many bytes we have recorded sending out */
                  pos,           /* Where the send actually is */
                  bytes2send,    /* How much total to send */
                  packets;       /* How many packets were transferred */

    time_t end_time;

protected:

    int  send_next_packet(void);

    void close_all(void)
    {
        if (file > -1)
        {
            close(file);
            file = -1;
        }
        dcc::close_all();
    }
};
  


/* Keeps track of all DCCs. Implementation is in
 * conn.cpp */
class dcc_list_t
{
private:
    char * filename;
    conn * owner;
    dcc  * ptr;
    bool islog;
    static linkedlist<dcc_list_t> list;

public:
    dcc_list_t(conn *, dcc *, const char *);
    inline ~dcc_list_t(void);
    friend class conn;
    friend int check_timers(void);
};


enum {
    DCC_ACCEPTED = 5,
    DCC_CLOSED,
    DCC_SEND_TIMEDOUT,
    DCC_PIPE_TIMEDOUT,
    DCC_PIPE_ESTABLISHED,
    DCC_SEND_ESTABLISHED,
    DCC_SEND_COMPLETE,
    DCC_ERROR = 0xDEAD
};


#endif
