// config.h 

#ifndef __config_h
#define __config_h

#include <stdlib.h>
#include "general.h"
#include "objset.h"
#include "ezbounce.h"


extern int reload_config_file(struct config_struct *, const char *file);
extern int load_config_file(struct config_struct *, const char *file);

class admin_block;
class misc_block;


#define DEF_MIN_CLIENT_IQ   512
#define DEF_MAX_CLIENT_IQ   4096
#define DEF_MIN_SERVER_IQ   512
#define DEF_MAX_SERVER_IQ   12000
#define DEF_MAX_IDLE_TIME    0
#define DEF_MAX_REGISTER_TIME 25
#define DEF_MAX_DNS_WAIT_TIME 15

          
enum {    
    /* These are also used with config_struct::flags */
    KILL_WHEN_FULL        = 0x8,
    DROP_ON_DISCONNECT    = 0x10, 
    PREVENT_SELF_CONNECTS = 0x20, 
    ENABLE_DETACH_COMMAND = 0x40,
    NO_REVERSE_LOOKUPS    = 0x80,  
    ENABLE_VHOST_COMMAND  = 0x100,
    ENABLE_FAKE_IDENTS    = 0x200,
    AUTO_FAKE_IDENT       = 0x400,
    ENABLE_OUTGOING_DCC_PROXYING = 0x800,
    ENABLE_INCOMING_DCC_PROXYING =  0x1000,
    ENABLE_AUTO_DETACH    = 0x2000,
    
    WRITE_PIDFILE            = 0x8000,
    ENABLE_PUBLIC_LOGGING    = 0x10000,
    ENABLE_PRIVATE_LOGGING   = 0x20000,
    ENABLE_SEPERATE_LOGGING  = 0x40000,
    LOG_OPTIONS = ENABLE_PUBLIC_LOGGING | ENABLE_PRIVATE_LOGGING
};


struct config_struct 
{
    char           * configfile;
    char           * logfile;
    char           * pidfile;
    char           * ports;
    char           * dcc_ports;
    char           * password;
    char           * logdir;
    char           * motd_file;
    char           * autoserver;
    
    unsigned long  min_clientQ, min_serverQ, max_serverQ, max_clientQ;

    unsigned       flags;
    unsigned       log_options;
    unsigned long  max_logsize;
    unsigned       max_failed_passwords, max_failed_admins;
    short          max_dns_wait_time;   
    time_t         max_idle,                     /* overall idle time limit */
                   max_register_time;            /* time limit for user to register w/ proxy */
    struct in_addr iface,                        /* vhost to listen on */
                   iface_conn;                   /* vhost to do connections on */
    admin_block    * admins;
    misc_block     * vhost_table;
};

class misc_block
{
protected:
    obj_set<const char> stuff;

public:
    void add(const char * thing)
    {
        /* we must duplicate it, or it could be a pointer to a variable
           on the stack that we add.. see destructor */
        stuff.add(my_strdup(thing));
    }
    unsigned num(void)
    {
        return stuff.num;
    }
    ~misc_block()
    {
        for (unsigned i = 0; i < stuff.num; i++)
            delete[] stuff.objs[i];
    }
    bool have(const char * what)
    {
        for (unsigned i = 0;  i < stuff.num; i++)
            if (strcasecmp(stuff.objs[i], what) == 0)
                return 1;
        return 0;
    }
    bool get(unsigned idx, char * buff, u_long size)
    {
        if (idx >= stuff.num)
            return 0;
        safe_strcpy(buff, stuff.objs[idx], size);
        return 1;
    }
};  

class admin_block : public misc_block 
{
private:
    char admin_password[PASSWORD_LENGTH];
    char admin_name[NICKNAME_LENGTH];
public:
    void set_credentials(const char * username, const char * password)
    {
        safe_strcpy(admin_name, username, sizeof(admin_name));
        safe_strcpy(admin_password, password, sizeof(admin_password));
    }
    bool authorized(const char *, const char *, const char *);
} ;


extern struct config_struct config;
#endif

